BEM.DOM.decl('b-banner-preview2', {

    onSetMod: {

        js: function() {
            this._toggleListenChangeViewModel(true);
        },

        view: function(modName, newViewValue, currentViewValue) {
            // в РМП и ТГО при изменении типа объявления нужно динамически менять view-модель превью
            var needReloadViewModel = this._getViewModelName(newViewValue) !== this._getViewModelName(currentViewValue);

            // afterCurrentEvent нужен для того, чтобы вызвать метод `_generateHtmlAllElems` уже после установки
            // модификатора `view`, т.к. он влияет на отрисовку блока
            this.afterCurrentEvent(function() {
                if (needReloadViewModel) {
                    this._toggleListenChangeViewModel(false);
                    this.getViewModel() && this.getViewModel().destruct();
                    this._viewModel = null;
                }

                BEM.DOM.update(this.domElem, this._generateHtmlAllElems());

                needReloadViewModel && this._toggleListenChangeViewModel(true);
            });
        }

    },

    /**
     * Подписывается/отписывается на изменения view-модели
     * и создает view-модель, если ее нет
     * @param {Boolean} condition
     * @returns {BEM.DOM}
     * @private
     */
    _toggleListenChangeViewModel: function(condition) {
        return this.getViewModel()[condition ? 'on' : 'un']('change', this._onModelsChange, this);
    },

    /**
     * Возвращает view-модель блока
     * Если ее нет - то создает
     * @returns {BEM.MODEL}
     */
    getViewModel: function() {
        if (!this._viewModel) {
            var modelsParams = this.params.modelsParams,
                vmParams = modelsParams.vmParams,
                dmsIds = modelsParams.dmsIds,
                // для РМП (чтобы не ломать), нужно будет переделать на dmsIds
                dmsParams = modelsParams.dmsParams,
                groupType = this._getGroupType(),
                viewType = this.getMod('view');

            this._viewModel = vmParams && BEM.MODEL.getOne(vmParams) ||
                BEM.MODEL.create(this._getViewModelName(viewType));

            (dmsIds || dmsParams) && this._viewModel.init(dmsIds, groupType);
        }

        return this._viewModel;
    },

    /**
     * Возвращает тип группы
     * @returns {String}
     */
    _getGroupType: function() {
        return this.getMod('type').replace(/-/g, '_');
    },

    /**
     * Возвращает имя текущей view-модели блока
     * @param {String} viewType
     * @returns {String}
     */
    _getViewModelName: function(viewType) {

        return this.params.modelsParams.vmParams ||
            u['b-banner-preview2'].getNameByType(this._getGroupType(), viewType);
    },

    /**
     * Обработчик изменений полей модели баннера
     * Вызывает перерисовку првеью
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Array} data.changedFields Список измененных полей
     * @param {Boolean} [data.inited] Флаг говорящий о том, что `change` произошел из-за инициализации модели
     * @private
     */
    _onModelsChange: function(e, data) {
        if (data.inited) return;

        this._repaintElems(this._getNeedRepaintElemsList(data.changedFields));
    },

    /**
     * Перерисовывает элементы,
     * если какого-то элемента не существует - перерисовывает все содержимое блока
     * @param {String[]} elemsName Список элементов, которые нужно перерисовать
     * @private
     */
    _repaintElems: function(elemsName) {
        if (!(elemsName || []).length) return;

        var cacheElems = {},
            allElemsExist = elemsName.every(function(elemName) {
                var elem = cacheElems[elemName] = this.findElem(elemName);

                return elem.length;
            }, this);

        if (allElemsExist) {
            elemsName.forEach(function(elemName) {
                BEM.DOM.replace(cacheElems[elemName], this._generateHtmlOneElem(elemName));
                this.dropElemCache(elemName);
            }, this);
        } else {
            BEM.DOM.update(this.domElem, this._generateHtmlAllElems());
            this.dropElemCache(elemsName.join(' '));
        }
    },

    /**
     * Возвращает строку с html-ем одного элемента для текущего view
     * @param {String} elemName Имя элемента
     * @returns {String}
     * @private
     */
    _generateHtmlOneElem: function(elemName) {
        return this._generateHtml(elemName);
    },

    /**
     * Возвращает строку с html-ем всех элементов для текущего view (без ноды самого блока)
     * @returns {String}
     * @private
     */
    _generateHtmlAllElems: function() {
        return this._generateHtml();
    },

    /**
     * Возвращает строку с html-ем одного элемента либо всех внутренностей блока для текущего view
     * @param {String} [elemName] Имя элемента
     * @returns {String}
     * @private
     */
    _generateHtml: function(elemName) {
        return BEMHTML.apply({
            block: this.__self.getName(),
            mods: { type: this.getMod('type'), view: this.getMod('view') },
            data: this.getCtxData(),
            staticData: this.params.staticData,
            _onlyContent: true,
            content: elemName ? { elem: elemName } : false
        });
    },

    /**
     * Переворачивает объект зависимостей
     * { domain: ['isHrefHasParams', 'vcard'] } ->
     * { isHrefHasParams: ['domain'], vcard: ['domain'] }
     * @param {Object} obj
     * @returns {Object}
     * @private
     */
    _mirrorDepends: function(obj) {
        this._dependsCache || (this._dependsCache = {});

        return this._dependsCache[this.getMod('view')] ||
            (this._dependsCache[this.getMod('view')] = Object.keys(obj).reduce(function(result, elemName) {
                obj[elemName].forEach(function(ctxField) {
                    result[ctxField] = (result[ctxField] || []).concat(elemName);
                });

                return result;
            }, {}));
    },

    /**
     * Возвращает список элементов, которые нужно перерисовать
     * @param {Array} ctxDataFields Поля входных данных, которые действительно изменились
     * @returns {Array|undefined}
     * @private
     */
    _getNeedRepaintElemsList: function(ctxDataFields) {
        if (!(ctxDataFields || []).length) return;

        // получаем список зависимостей из конкретного view
        var depends = this._mirrorDepends(this._getElemsDepends() || {}),
            noRepeatHelper = {};

        return ctxDataFields
            .reduce(function(result, ctxDataField) {
                depends[ctxDataField] && (result = result.concat(depends[ctxDataField]));

                return result;
            }, [])
            .filter(function(elemName) {
                if (noRepeatHelper[elemName]) return false;

                return noRepeatHelper[elemName] = true;
            });
    },

    /**
     * Обработчик клика по псевдо-ссылке
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _onLinkClick: function(e, data) {
        var domElem = e.block.domElem,
            params = this.params;

        this.findElem('additions-link').is(domElem) && this._onAdditionClick(domElem);

        (!params.hasOrganization || params.preferVcardOverPermalink) && this.findElem('v-card').is(domElem) && this.openVcard();

        this.findElem('title-to-vcard').is(domElem) && this._onTitleToVcardClick(e, data);
    },

    /**
     * Обработчик клика по дополнениям
     * @param {jQuery} domElem
     * @private
     */
    _onAdditionClick: function(domElem) {
        this._getPopup()
            .setContent(BEMHTML.apply({
                block: this.__self.getName(),
                mods: { type: this.getMod('type'), view: this._getAdditionView(), readonly: 'yes' },
                data: this.getCtxData()

            }))
            .toggle(domElem);
    },

    /**
     * Возвращает тип view, который показывается при клике на "Дополнения"
     * @returns {*}
     * @private
     */
    _getAdditionView: function() {
        var adgroupType = this.getMod('type').replace(/-/g, '_');

        switch (adgroupType) {
            case 'mobile_content':
                return this.getCtxData().image ? 'mobile-content-partner-poster' : 'mobile-content-search';

            default:
                return 'extended-base';
        }
    },

    /**
     * Возвращает попап для отображения дополнений
     * @returns {*}
     * @private
     */
    _getPopup: function() {
        return BEM.blocks['b-shared-popup'].getInstance(
            { animate: 'yes', 'has-close': 'yes' },
            { directions: ['right-middle-middle', 'top-left-right', 'bottom-left-right'] });
    },

    /**
     * Возвращает параметры для попапа визитки
     * @returns {{action: string, method: string, data: object[]}}
     * @private
     */
    _getVCardParams: function() {
        var ctxData = this.getCtxData(),
            fromClient = ctxData.loadVCardFromClient,
            vCardReq = {
                action: u.getUrl(),
                method: 'GET',
                data: [
                    { name: 'cmd', value: 'showContactInfo' },
                    { name: 'cid', value: ctxData.cid },
                    { name: 'bid', value: ctxData.bid }
                ]
            };

        if (fromClient) {
            // Если стоит флаг fromClient (loadVCardFromClient)
            // То берем данные и отправляем POST, т.к. на сервере визитки еще нет или данные не актуальны
            vCardReq.method = 'POST';
            vCardReq.data.push({ name: 'from', value: 'edit' });
            u['b-banner-preview2'].getVCardFields().forEach(function(name) {
                vCardReq.data.push({
                    name: name,
                    // специфическое экранирование - заменяет только символы <, >, &
                    value: ctxData[name] || ''
                });
            });
        }

        return vCardReq;
    },

    /**
     * Открывает попап с визиткой
     */
    openVcard: function() {
        var ModelPopupOpener = BEM.blocks['b-modal-popup-opener'],
            uniqId = this.params.uniqId,
            windowSettings = ModelPopupOpener.getSettings({ height: 750 });

        ModelPopupOpener.openWindow('', uniqId, windowSettings);
        ModelPopupOpener.submitForm(uniqId, this._getVCardParams());
    },

    /**
     * Обработчик клика по заголовку, когда он должен открывать визитку
     * @param {jQuery.Event} e
     * @private
     */
    _onTitleToVcardClick: function(e) {
        this.openVcard();

        e.preventDefault();
    },

    /**
     * Возвращает входные данные, по которым отрисовался блок
     * @returns {Object}
     */
    getCtxData: function() {
        return this.getViewModel().toJSON();
    },

    /**
     * Возвращает data-модель по ключу
     * @param {String} modelKey Ключ модели modelKey
     * @returns {BEM.MODEL|null}
     */
    getDM: function(modelKey) {
        return this.getViewModel().getDM()[modelKey] || null;
    },

    destruct: function() {
        this._toggleListenChangeViewModel(false);

        this.getViewModel() && this.getViewModel().destruct();

        return this.__base.apply(this, arguments);
    },

    _onHashFlagsChange: function(e, data) {
        this.getDM('banner') && this.getDM('banner').setHashFlagsWithDependencies(data.value);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'link', function(e) {
                this._onLinkClick(e);
            })
            .liveInitOnBlockInsideEvent('flags-change', 'b-banner-age-label2', function(e, data) {
                this._onHashFlagsChange(e, data);
            })
            .liveInitOnBlockInsideEvent('flags-change', 'b-banner-adv-alert2', function(e, data) {
                this._onHashFlagsChange(e, data);
            });

        return false;
    }

});
