block('b-banner-reject-reasons')(
    elem('array-list').def()(function() {
        return applyCtx({
            elem: 'list',
            content: this.ctx.list.map(function(diag) {
                return {
                    elem: 'list-element',
                    content: diag.diag_text
                };
            })
        });
    }),

    content()(function() {
        var data = this.ctx.data,
            diags = data.diags || {},
            bannersDiag = diags.banner || [],
            phrasesDiag = diags.phrases || [],
            contactInfoDiag = diags.contactinfo || [],
            sitelinksDiag = (data.badSitelinks || []).reasons,
            bid = data.bid,
            result = [],
            showDetailsUrl = false,
            keys = function(value) {
                return typeof value == 'object' ? Object.keys(value) : [];
            };

        if (Object.keys(diags).length) {
            result.push([
                {
                    elem: 'sub-header',
                    content: iget2('b-banner-reject-reasons', 'prichiny-otkloneniya', 'Причины отклонения')
                },
                {
                    elem: 'content',
                    content: [
                        bannersDiag.length > 0 && [
                            iget2(
                                'b-banner-reject-reasons',
                                'obyavlenie-otkloneno-po-sleduyushchim',
                                'Объявление отклонено по следующим причинам: {reasons}',
                                {
                                    reasons: function() {
                                        return {
                                            elem: 'list',
                                            content: bannersDiag.map(function(diag) {
                                                var result = [{
                                                    elem: 'list-element',
                                                    content: diag.diag_text
                                                }];

                                                if (diag.show_details_url) {
                                                    result.push({
                                                        elem: 'details',
                                                        bid: bid,
                                                        id: diag.diag_id
                                                    });
                                                    showDetailsUrl = true;
                                                }

                                                return result;
                                            })
                                        };
                                    }()
                                }
                            )
                        ],
                        phrasesDiag.length > 0 && iget2(
                            'b-banner-reject-reasons',
                            'klyuchevye-frazy-phrases-otkloneny',
                            'Ключевые фразы {phrases} отклонены по следующим причинам: {reasons}',
                            {
                                phrases: function() {
                                    return (keys(data.badPhrases).length > 0 || keys(data.badRubrics).length > 0) && {
                                        elem: 'phrases',
                                        content: {
                                            elem: 'list',
                                            content: [
                                                keys(data.badPhrases).map(function(key) {
                                                    return {
                                                        elem: 'list-element',
                                                        content: data.badPhrases[key]
                                                    };
                                                }),
                                                keys(data.badRubrics).map(function(key) {
                                                    return {
                                                        elem: 'list-element',
                                                        content: data.badRubrics[key]
                                                    };
                                                })
                                            ]
                                        }
                                    };
                                }(),

                                reasons: function() {
                                    return {
                                        elem: 'array-list',
                                        list: phrasesDiag
                                    };
                                }()
                            }
                        ),

                        data.vcardId && contactInfoDiag.length > 0 && [
                            iget2('b-banner-reject-reasons', 'po-kontaktnoy-informacii-reasons', 'по контактной информации: {reasons}', {
                                reasons: function() {
                                    return {
                                        elem: 'array-list',
                                        list: contactInfoDiag
                                    };
                                }()
                            })
                        ],
                        diags.sitelinks_set && sitelinksDiag.length > 0 &&
                            iget2('b-banner-reject-reasons', 'bystrye-ssylki-otkloneny-po', 'Быстрые ссылки отклонены по следующим причинам: {reasons}', {
                                reasons: function() {
                                    return {
                                        elem: 'array-list',
                                        list: sitelinksDiag
                                    };
                                }()
                            }),
                        diags.image && keys(data.badImages).map(function(key) {
                            var image = data.badImages[key];

                            return iget2(
                                'b-banner-reject-reasons',
                                'izobrazhenie-image-otkloneno-po',
                                'Изображение {image} отклонено по следующим причинам: {reasons}',
                                {
                                    image: function() {
                                        return [
                                            {
                                                tag: 'image',
                                                attrs: {
                                                    src: '/images/' + image.image_hash + '/x90',
                                                    alt: (image.name || '').toString()
                                                }
                                            },
                                            {
                                                elem: 'image-title',
                                                content: (image.name || '').toString()
                                            }
                                        ];
                                    }(),

                                    reasons: function() {
                                        return {
                                            elem: 'array-list',
                                            list: image.reasons
                                        };
                                    }()
                                }
                            );
                        }),
                        keys(diags.media_group).map(function(key) {
                            var group = diags.media_group[key];

                            return iget2('b-banner-reject-reasons', 'po-usloviyu-u-group', 'по условию У-{group} {reasons}', {
                                group: function() {
                                    return key;
                                }(),

                                reasons: function() {
                                    return {
                                        elem: 'list',
                                        content: keys(group).map(function(gkey) {
                                            return {
                                                elem: 'list-element',
                                                content: group[gkey].diag_text
                                            };
                                        })
                                    };
                                }()
                            });
                        }),
                        keys(diags.media_banner).map(function(key) {
                            var mediaBanner = diags.media_banner[key];

                            return iget2('b-banner-reject-reasons', 'po-banneru-t-banner', 'по баннеру Т-{banner} {reasons}', {
                                banner: function() {
                                    return key;
                                }(),

                                reasons: function() {
                                    return {
                                        elem: 'list',
                                        content: keys(mediaBanner).map(function(bkey) {
                                            return {
                                                elem: 'list-element',
                                                content: mediaBanner[bkey].diag_text
                                            };
                                        })
                                    };
                                }()
                            });
                        })
                    ]
                }
            ]);
        } else {
            result.push({
                elem: 'no-data',
                content: iget2('b-banner-reject-reasons', 'dannyh-net', 'Данных нет')
            });

            result.push([
                {
                    elem: 'break'
                }
            ]);
        }

        if (!showDetailsUrl) {
            result.push({
                elem: 'all-reasons',
                content: iget2(
                    'b-banner-reject-reasons',
                    'oznakomitsya-so-vsemi-vozmozhnymi',
                    'Ознакомиться со всеми возможными причинами отклонения рекламных материалов можно {link}.',
                    {
                        link: function(text) {
                            return {
                                block: 'link',
                                url: u.getCommonHelpUrl('/direct/qanda/ads.xml#reject'),
                                content: text
                            };
                        }(iget2('b-banner-reject-reasons', 'oznakomitsya-so-vsemi-vozmozhnymi-param-link', 'здесь')),

                        context: 'link - здесь'
                    }
                )
            });
        }

        result.push([
            {
                elem: 'break'
            }
        ]);

        result.push({
            elem: 'edit-note',
            content: iget2(
                'b-banner-reject-reasons',
                'vy-mozhete-ispravit-tekst',
                'Вы можете исправить текст объявления или ключевые фразы, пройдя по ссылке "Редактировать объявление" на странице кампании.'
            )
        });

        result.push({
            elem: 'influent-args',
            content: iget2(
                'b-banner-reject-reasons',
                'esli-u-vas-est',
                'Если у Вас есть аргументы, которые могут повлиять на текущий результат модерации, Вы можете отправить их в {link}. Если Вам необходимо предоставить документы, пожалуйста, используйте  {form_link}.',
                {
                    link: function(text) {
                        return {
                            block: 'link',
                            url: iget2(
                                'b-banner-reject-reasons',
                                'http-feedback2-yandex-ru',
                                'http://feedback2.yandex.ru/direct/moderation/dissent/?from=dissent'
                            ),
                            content: text
                        };
                    }(iget2('b-banner-reject-reasons', 'esli-u-vas-est-param-link', 'службу поддержки')),

                    form_link: function(text) {
                        return {
                            block: 'link',
                            url: iget2(
                                'b-banner-reject-reasons',
                                'https-feedback2-yandex-ru',
                                'https://feedback2.yandex.ru/direct/moderation/document/?from=docs'
                            ),
                            content: text
                        };
                    }(iget2('b-banner-reject-reasons', 'esli-u-vas-est-param-form_link', 'соответствующую форму')),

                    context: 'link - службу поддержки; form_link - соответствующую форму'
                }
            )
        });

        return result;
    }),

    elem('details').content()(function() {
        var bid = this.ctx.bid,
            id = this.ctx.id,
            igetLinkHash = {
                link: function(text) {
                    return {
                        block: 'link',
                        url: u.getUrl('showDiagDetails', {
                            bid: bid,
                            diag_id: id
                        }),
                        content: text
                    };
                },
                example: function(text) {
                    return {
                        elem: 'guarantee-letter-example-link',
                        content: text
                    };
                }
            };

        return ['102', '2', '43'].indexOf(this.ctx.id) !== -1 ?
            iget2(
                'b-banner-reject-reasons',
                'posmotret-detalnye-kommentarii-i',
                'Посмотреть детальные комментарии и скачать {example} вы можете {link}.',
                igetLinkHash
            ) :
            iget2(
                'b-banner-reject-reasons',
                'posmotret-detalnye-kommentarii-vy',
                'Посмотреть детальные комментарии вы можете {link}.',
                igetLinkHash
            );
    }),

    elem('list').tag()('ul'),
    elem('list-element').tag()('li'),
    elem('break').tag()('br'))
