block('b-banner-sitelinks')(
    elem('switcher-text').tag()('span'),

    def()(function() {
        var siteLinksDescriptionExists = (this.ctx.banner.sitelinks || []).some(function(sitelink) {
            return sitelink.description;
        });

        return applyNext({
            'mods.description': siteLinksDescriptionExists ? 'exist' : this.mods.description,
            banner: this.ctx.banner,
            modelParams: this.ctx.modelParams,
            prevBid: this.ctx.prevBid
        });
    }),

    js()(function() {
        return {
            modelName: this.modelParams.name,
            modelId: this.banner.modelId
        };
    }),

    content()(function() {
        var banner = this.banner,
            sitelinks = banner.sitelinks || [],
            isNotEmpty = sitelinks.length && sitelinks[0].title;

        return [
            {
                block: 'b-outboard-controls',
                mix: [{
                    block: 'b-banner-sitelinks',
                    elem: 'outboard'
                }],
                js: { popupId: 'sitelinks-selector-control' },
                content: {
                    elem: 'switcher',
                    mix: [{
                        block: 'b-banner-sitelinks',
                        elem: 'switcher'
                    }],
                    js: {
                        innerBlockParams: {
                            modelParams: this.modelParams,
                            prevBid: this.prevBid
                        }

                    },
                    switcherText: isNotEmpty ? iget2('b-banner-sitelinks', 'izmenit', 'Изменить') : iget2('b-banner-sitelinks', 'dobavit', 'Добавить')
                }
            },
            {
                elem: 'outcome',
                sitelinks: sitelinks
            }
        ];
    })
);
