BEM.DOM.decl({ block: 'b-banner-sitelinks' }, {
    onSetMod: {
        js: function() {
            var modelId = this.params.modelId,
                modelName = this.params.modelName;

            this._bannerModel = BEM.MODEL.getOne({ name: modelName || 'm-banner', id: modelId });
            this._sitelinksModel = this._bannerModel.get('sitelinks');
            this._outboard = this.findBlockInside('b-outboard-controls');
            this._subMan = BEM.create('i-subscription-manager');

            this._initEvents();
        }
    },

    /**
     * Инициализирует события изменения моделей
     * @returns {BEM}
     * @private
     */
    _initEvents: function() {
        this._subMan.wrap(this._sitelinksModel)
            .on('fix', function() {
                this._outboard.toggleSwitchButton(false);
                this._onSitelinksModelUpdated();
            }, this)
            .on('change', function() {
                //если меняется модель сайтлинков и при этом открыт попап редактирования - временно дизейблим
                if (this._outboard.isShown()) {
                    this._outboard.toggleSwitchButton(this._sitelinksModel.isChanged());
                } else {
                    this._onSitelinksModelUpdated();
                }
            }, this);

        this._subMan.on(this._outboard, 'hide', function() {
            this._outboard.toggleSwitchButton(false);
        }, this);

        return this;
    },

    /**
     * Обрабатывает изменения модели сайтлинков
     * @returns {BEM}
     * @private
     */
    _onSitelinksModelUpdated: function() {
        var values = {},
            i;

        for (i = 0; i < u.consts('SITELINKS_NUMBER'); i++) {
            values['title' + i] = this._sitelinksModel.get('title' + i);
            values['href' + i] = this._sitelinksModel.get('href' + i);
            values['url_protocol' + i] = this._sitelinksModel.get('url_protocol' + i);
        }

        this.trigger('change');

        return this._updateView();
    },

    /**
     * Перерисовывает внешний вид и заполняет скрытые поля
     * @returns {BEM}
     * @private
     */
    _updateView: function() {
        var sitelinksArray = [],
            isNotEmpty = false,
            sitelinkTitle,
            sitelinkHref,
            sitelinkDescription,
            sitelinkTurbo,
            siteLinksDescriptionExists = false;

        for (var i = 0; i < u.consts('SITELINKS_NUMBER'); i++) {
            sitelinkTitle = this._sitelinksModel.get('title' + i);
            sitelinkHref = this._sitelinksModel.get('href' + i);
            sitelinkDescription = this._sitelinksModel.get('description' + i);
            sitelinkTurbo = this._sitelinksModel.get('turbolanding' + i);

            siteLinksDescriptionExists = siteLinksDescriptionExists ||
                (sitelinkDescription && sitelinkDescription !== '');

            isNotEmpty = isNotEmpty || !!(sitelinkTitle || sitelinkHref);

            if (sitelinkHref || sitelinkTurbo) {
                sitelinksArray.push({
                    title: sitelinkTitle,
                    description: sitelinkDescription
                });
            }
        }

        this.setMod('description', siteLinksDescriptionExists ? 'exist' : '');

        this._outboard.setSwitcherText(isNotEmpty ? iget2('b-banner-sitelinks', 'izmenit', 'Изменить') : iget2('b-banner-sitelinks', 'dobavit', 'Добавить'));

        BEM.DOM.replace(this.findElem('outcome'), BEMHTML.apply({
            block: 'b-banner-sitelinks',
            elem: 'outcome',
            sitelinks: sitelinksArray
        }));

        return this;
    }
}, {

    live: function() {
        this.liveInitOnBlockEvent('init', 'b-outboard-controls');
    }
});
