BEM.DOM.decl({ block: 'b-banner-status', modName: 'updatable', modVal: 'yes' }, {

    onSetMod: {

        js: function() {
            this._onStatusDataChange = $.debounce(this._onStatusDataChange, 100);

            this._listenModelFields = [
                'status', 'statusAutobudgetShow', 'statusShow', 'groupStatusModerate', 'statusModerate',
                'day_budget', 'autobudget', 'before_moderation'
            ].join(' ');

            this._getModelBanner().on(this._listenModelFields, 'change', this._onStatusDataChange, this);
        }

    },

    /**
     * Изменились данные по которым строится статус баннера
     * @private
     */
    _onStatusDataChange: function() {
        BEM.DOM.replace(this.domElem, BEMHTML.apply({
            block: this.__self.getName(),
            mods: { updatable: 'yes' },
            banner: this._getModelBanner().toJSON(),
            hideOngoingShowsStatus: this.params.hideOngoingShowsStatus,
            js: this.params
        }));
    },

    /**
     * Возвращает модель баннера
     * @returns {BEM.MODEL}
     * @private
     */
    _getModelBanner: function() {
        return this._modelBanner || (this._modelBanner = BEM.MODEL.getOrCreate(this.params.modelParams));
    },

    destruct: function() {
        this._getModelBanner().un(this._listenModelFields, 'change', this._onStatusDataChange, this);

        this.__base.apply(this, arguments);
    }

});
