block('b-banner-status')(

    content()(function() {
        var ctx = this.ctx,
            banner = ctx.banner || {},
            isCPM = u.campaign.isCpm(banner.adgroup_type),
            useBanner = banner.adgroup_type == 'performance' || banner.adgroup_type == 'mcbanner',
            hideAdminStatusStop = (banner.statusShow !== 'Yes' || banner.statusAutobudgetShow !== 'No'),
            needToShowModEditNotice = banner.before_moderation && banner.before_moderation.showModEditNotice === 'Yes',
            iconStatusModerate = banner.iconStatusModerate,
            statusText = !banner.status ? '' : banner.status.split(/\s?\.\s?/).map(function(text, i, array) {
                return {
                    elem: 'status',
                    elemMods: { last: i === array.length - 1 ? 'yes' : undefined },
                    content: [text, '.']
                };
            }),
            text,
            isStoppedByCampDayBudget = banner.day_budget > 0 && banner.statusShow === 'Yes' &&
                banner.statusAutobudgetShow === 'No' && banner.day_budget_show_mode === 'stretched',
            isStoppedByCampWeekBudget = banner.autobudget === 'Yes' && banner.statusShow === 'Yes' &&
                banner.statusAutobudgetShow === 'No' && banner.BannerID > 0,
            isStoppedByWalletDayBudget = banner.wallet_day_budget > 0 && banner.statusShow === 'Yes' &&
                banner.statusAutobudgetShow === 'No' && banner.wallet_day_budget_show_mode === 'stretched';
        /*
        * Временно закрываем отображения причин для перфоманса DIRECT-52520
        * */
        if (banner.declined_show && banner.adgroup_type !== 'performance') {
            statusText = [
                statusText,
                ' (',
                {
                    block: 'b-moderation-reject',
                    bid: banner.bid,
                    objectType: banner.ad_type === 'cpc_video' ?
                        'video' :
                        u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], banner.adgroup_type) ?
                            'banner' :
                            'common',
                    additionsItemsIds: u._.map(
                        u._.filter(banner.callouts || [], { status_moderate: 'No' }),
                        'additions_item_id'
                    )
                },
                ')'
            ];
        }

        if (needToShowModEditNotice) {
            var editCreateTime = u.moment.unix(banner.before_moderation.edit_createtime),
                today = u.moment();

            needToShowModEditNotice = today.diff(editCreateTime, 'days') < 7;
        }

        text = [
            !banner.ignoreIconStatusModerate && iconStatusModerate && iconStatusModerate !== 'Yes' &&
                iconStatusModerate !== 'Ready' && banner.icon_hash &&
                {
                    block: 'b-banner-status',
                    elem: 'mobile-warning',
                    content: iconStatusModerate === 'No' ?
                        iget2('b-banner-status', 'ikonka-prilozheniya-otklonena-na', 'Иконка приложения отклонена на модерации.') :
                        iget2('b-banner-status', 'ikonka-prilozheniya-ozhidaet-moderacii', 'Иконка приложения ожидает модерации.')
                },
            // DIRECT-47806 - поля мобильного контента группы, см. dm-mobile-content-banner.utils.js
            banner.isAvailableMobileContent === false && {
                block: 'b-banner-status',
                elem: 'mobile-warning',
                content: iget2('b-banner-status', 'obyavlenie-bylo-ostanovleno-monitoringom', 'Объявление было остановлено мониторингом приложений.')
            },
            statusText && {
                block: 'b-banner-status',
                elem: 'admin-status',
                content: [
                    statusText,
                    // динамические объявления не сгенерированы DIRECT-48191
                    // смарт-баннеры не сгенерированы DIRECT-54040
                    // TODO придумать структуру для banner.status,
                    // TODO ориентироваться по текущей строке сложно, нет возможность обработать конкретный статус
                    // задача на рефакторинг DIRECT-55085
                    !!banner.is_bl_nothing_generated && {
                        block: 'b-help-link',
                        mix: {
                            block: 'b-banner-status',
                            elem: 'not-created-help'
                        },
                        mods: { type: 'modal' },
                        stretched: true,
                        url: banner.adgroup_type === 'performance' ?
                            u.getHelpUrl('smart-banners-not-created') :
                            u.getHelpUrl('dynamic-text-ads-not-created')
                    }
                ]
            },
            //DIRECT-30244 попросить бекэнд присылать в getAdGroup groupStatusModerate в баннерах
            !ctx.hideOngoingShowsStatus && banner.BannerID && banner.statusActive == 'Yes' &&
                (banner.statusModerate != 'Yes' ||
                    ('groupStatusModerate' in banner && banner.groupStatusModerate != 'Yes')) && {
                        block: 'b-banner-status',
                        elem: 'admin-status',
                        elemMods: { type: 'show' },
                        content: [(useBanner ?
                            iget2('b-banner-status', 'idut-pokazy-predydushchey-versii', 'Идут показы предыдущей версии баннера') :
                            iget2('b-banner-status', 'idut-pokazy-predydushchey-versii-101', 'Идут показы предыдущей версии объявления')),
                            '!']
                    },
            // сообщение об остановки показа баннерров
            (isStoppedByCampDayBudget || isStoppedByCampWeekBudget || isStoppedByWalletDayBudget) && {
                block: 'b-banner-status',
                elem: 'admin-status',
                elemMods: {
                    type: 'stop',
                    hidden: hideAdminStatusStop ? 'yes' : 'no'
                },
                content: (function() {
                    // Показ объявления может быть остановлен, тогда нам БК нам шлет banner.statusAutobudgetShow === 'No'
                    // но он не умеет определять причину остановки, поэтому мы пытаемся ее определить самостоятельно
                    // на основе настроек стратегии и ОС
                    // если выполняются условия и для настроек ОС и для настроек стратегии - в приоритете сообщение про
                    // ограничение дневного бюджета на ОС
                    if (isStoppedByWalletDayBudget) {
                        return useBanner ?
                            iget2(
                                'b-banner-status',
                                'pokazy-bannera-vremenno-priostanovleny',
                                'Показы баннера временно приостановлены, так как действует ограничение бюджета'
                            ) :
                            iget2(
                                'b-banner-status',
                                'pokazy-obyavleniya-vremenno-priostanovleny',
                                'Показы объявления временно приостановлены, так как действует ограничение бюджета'
                            );
                    }

                    if (isStoppedByCampDayBudget) {
                        return useBanner ?
                            iget2('b-banner-status', 'dnevnoy-byudzhet-vremenno-priostanovil', 'Дневной бюджет временно приостановил показ баннера') :
                            iget2('b-banner-status', 'dnevnoy-byudzhet-vremenno-priostanovil-102', 'Дневной бюджет временно приостановил показ объявления');
                    }

                    if (isStoppedByCampWeekBudget) {
                        return useBanner ?
                            iget2('b-banner-status', 'nedelnyy-byudzhet-vremenno-priostanovil', 'Недельный бюджет временно приостановил показ баннера') :
                            isCPM ?
                                iget2(
                                    'b-banner-status',
                                    'auto-byudzhet-vremenno-priostanovil',
                                    'Автоматическая стратегия временно приостановила кампанию. Показы начнутся в ближайший разрешенный в настройках день.'
                                ) :
                                iget2(
                                    'b-banner-status',
                                    'nedelnyy-byudzhet-vremenno-priostanovil-103',
                                    'Недельный бюджет временно приостановил показ объявления'
                                );
                    }
                })()
            },
            banner.isStatusOptimized && {
                block: 'b-banner-status',
                elem: 'status-optimized',
                content: iget2('b-banner-status', 'banner-skopirovan-v-nbsp', 'Баннер скопирован в&nbsp;оптимизированные')
            },
            // Сообщение об опечатках в текстах баннера
            needToShowModEditNotice && {
                block: 'b-banner-errata-informer',
                mix: [{ block: 'b-banner-status', elem: 'edit-notice' }],
                modelParams: this.ctx.js && this.ctx.js.modelParams,
                data: banner.before_moderation
            },
            banner['disabled_geo'] && {
                block: 'b-banner-status',
                elem: 'admin-status',
                elemMods: { 'minus-regions': 'yes' },
                content: [
                    banner['effective_geo'] === '' ?
                        (useBanner ?
                            iget2(
                                'b-banner-status',
                                'pokazy-bannerov-gruppy-zapreshcheny',
                                'Показы баннеров группы запрещены в соответствии с законодательством страны таргетинга или до предоставления соответствующей лицензии.'
                            ) :
                            iget2(
                                'b-banner-status',
                                'pokazy-obyavleniy-gruppy-zapreshcheny',
                                'Показы объявлений группы запрещены в соответствии с законодательством страны таргетинга или до предоставления соответствующей лицензии.'
                            )) :
                        (u.getGeoNames(banner['disabled_geo']).split(',').length > 1) ?
                            iget2('b-banner-status', 'pokazy-ogranicheny-zakonodatelstvom-regions', 'Показы ограничены законодательством: {regions}', {
                                regions: {
                                    block: 'dropdown',
                                    content: [
                                        {
                                            block: 'link',
                                            mix: [{ block: 'dropdown', elem: 'switcher' }],
                                            mods: { pseudo: 'yes' },
                                            content: iget2('b-banner-status', 'length', '{length}', {
                                                length: u.pluralize([
                                                    iget2('b-banner-status', 'strana', 'страна'),
                                                    iget2('b-banner-status', 'strany', 'страны'),
                                                    iget2('b-banner-status', 'stran', 'стран')], banner['disabled_geo'].split(',').length, '&nbsp;')
                                            })
                                        },
                                        {
                                            elem: 'popup',
                                            mix: [{ block: 'b-banner-status', elem: 'minus-regions-popup' }],
                                            content: u.getGeoNames(banner['disabled_geo'])
                                        }
                                    ]
                                },

                                context: 'regions - стран'
                            }) :
                            iget2('b-banner-status', 'pokazy-ogranicheny-zakonodatelstvom-region', 'Показы ограничены законодательством: {region}', {
                                region: u.getGeoNames(banner['disabled_geo']),
                                context: 'region - страна'
                            }),
                    '&nbsp;',
                    {
                        block: 'b-help-link',
                        url: u.getHelpUrl('legal-restrictions'),
                        mods: { type: 'modal' },
                        stretched: true,
                        mix: [{ block: 'b-banner-status', elem: 'disabled-geo-tooltip' }],
                        decoration: 'no'
                    },
                    '<br/>',
                    {
                        block: 'b-help-link',
                        url: u.getLegalUrl('adv_rules'),
                        text: iget2('b-banner-status', 'podrobnee', 'Подробнее'),
                        mix: [{ block: 'b-banner-status', elem: 'more-info' }]
                    }
                ]
            }
        ];

        // [false, null, 0, '', undefined, NaN] -> []
        text = u._.compact(text);

        banner.showAdminAttrs && (text = [text, {
            block: 'b-toggle',
            content: [
                {
                    elem: 'link',
                    mix: [{
                        block: 'b-banner-preview',
                        elem: 'admin-attrs-toggle'
                    }],
                    content: iget2('b-banner-status', 'pokazat-atributy', 'Показать атрибуты')
                },
                {
                    elem: 'toggle',
                    state: 'hidden',
                    items: [{
                        block: 'b-banner-preview',
                        elem: 'admin-attrs',
                        content: [
                            'statusModerate',
                            'groupStatusModerate',
                            'phoneflag',
                            'statusBsSynced',
                            'bstatusBsSynced',
                            'pstatusBsSynced',
                            'statusPostModerate',
                            'groupStatusPostModerate',
                            'statusMetricaStop',
                            'statusShow',
                            'statusActive',
                            'statusArch',
                            'flags'
                        ].map(function(attrName) {
                            return banner[attrName] && {
                                content: attrName + ': ' + banner[attrName]
                            };
                        })
                    }]
                }
            ]
        }]);

        if (!text.length) return '';

        return [{
            elem: 'wrap',
            text: text
        }];
    }),

    elem('wrap')(
        tag()('table'),
        content()(function() {
            return {
                tag: 'tr',
                content: [
                    {
                        elem: 'icon',
                        content: {
                            block: 'icon',
                            mods: { 'size-13': this.ctx.icon || 'info' },
                            mix: [{ block: 'b-banner-status', elem: 'icon-info' }]
                        }
                    },
                    {
                        elem: 'text',
                        content: this.ctx.text
                    }
                ]
            };
        })),

    elem('icon').tag()('td'),

    elem('text').tag()('td')

);
