BEM.DOM.decl({
    block: 'b-banner-storage-frame',
    modName: 'type',
    modVal: 'cpm-geoproduct',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    /**
     * Показывает блок в модальном окне
     * @param {'creatives'|'presets'|''|'add'|'preview'} type - вкладка, открытая по умолчанию (галерея/конструктор)
     * @param {String} clientId - id клиента
     * @param {Object} validationRules - правила валидации выбранных креативов
     * @param {Number} validationRules.maxCount - максимальное разрешенное для выбора количество креативов
     * @param {Object} validationRules.single - разрешен выбор только одного креатива на замену сохраненному
     * @param {Number} validationRules.single.width - ширина сохраненного креатива (должна соответствовать)
     * @param {Number} validationRules.single.height - высота сохраненного креатива (должна соответствовать)
     * @param {Boolean} isHTML5 — флаг ли креатив HTML5 баннером (DIRECT-72386)
     * @param {String} [productType] — тип продукта HTML5 конструктора
     */
    show: function(type, clientId, validationRules, isHTML5, productType) {
        this._validationRules = validationRules;
        this._isHTML5 = isHTML5;

        var sharedData = u['b-banner-storage-frame'].getSharedData('cpmGeoproduct', clientId, validationRules.single, { cpm_geoproduct: 1 });

        if (this._modal) {
            this._modal.show();
        }

        if (isHTML5) {
            this._renderHtml5Dna(clientId, productType, type === 'add' ? 'upload' : 'active', validationRules.single);
        } else {
            this._renderCanvasDna(sharedData, (type === 'presets' || type === 'add') ? 'constructor' : type);
        }
    }
});
