BEM.DOM.decl({
    block: 'b-banner-storage-frame',
    modName: 'type',
    modVal: 'mobile-content-video',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    /**
     * Показывает блок в модальном окне
     * @param {'creatives'|'presets'| 'edit'} type - вкладка, открытая по умолчанию (галерея/конструктор)
     * @param {Number} clientId - id клиента
     * @param {Object} [extraParams] - дополнительные параметры
     * @param {Number} [extraParams.creative_id] - id креатива
     * */
    show: function(type, clientId, extraParams) {
        if (this._modal) {
            this._modal.show();
        }

        var sharedData = u['b-banner-storage-frame'].getVideoSharedData(clientId, 'mobile_content_video');
        this._renderCanvasDna(sharedData, type);
    },

    /**
     * Получает с сервера информацию о выбранных креативах
     * @param {Object} data данные из конструктора
     * @param {Function} onSuccess callback на удачное завершение запроса
     * @param {Function} onError callback на неудачное завершение запроса
     * @private
     */
    _ajaxSend: function(data, onSuccess, onError) {
        var request = BEM.create('i-request_type_ajax', {
            url: u.consts('SCRIPT'),
            dataType: 'json',
            type: 'POST',
            cache: false,
            timeout: this._ajaxTimeout
        });

        request.get({
            ulogin: u.consts('ulogin') || '',
            cmd: 'searchVideoCreatives',
            creative_id: data.creativeIds.join(',')
        }, onSuccess, onError);
    },

    /**
     * Валидирует выбранные креативы и генерирует событие сохранения
     * @param {Object} response - ответ от бэкенда с информацией о выбранных креативах
     * @private
     */
    _validateAndSave: function(response) {
        this.trigger('select', response.result.creatives);
        this.hide();
    }

});
