BEM.DOM.decl({
    block: 'b-banner-storage-frame',
    modName: 'type',
    modVal: 'turbo-landings',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    /**
     * Показывает блок в модальном окне
     * @param {Number} clientId - id клиента
     * @param {Number} [selectedId] - id выбранной турбо-страницы
     * @param {Boolean} userHasSite - флаг, есть ли у пользователя сайт или турбо - основная страница
     * @param {Object} additionalParams - объект с дополнительными параметрами
     * @param {String} additionalParams.templateName - имя шаблона, с которым нужно открыть Конструктор
     * @param {Array} additionalParams.enableTemplates - массив white-list шаблонов
     * */
    show: function(clientId, selectedId, userHasSite, additionalParams) {
        var utils = u['b-banner-storage-frame'],
            pingUrl = utils.getTurboPingUrl();

        this._constructorUrl = utils.getTurboLandingsUrl(clientId, selectedId, userHasSite, additionalParams);

        if (this._modal) {
            this._modal.show();
        }

        this._loadConstructor(this._constructorUrl, pingUrl);

        if (additionalParams.templateName) {
            BEM.blocks['b-metrika2'].params({
                params: {
                    turbolandingConstructor: {
                        open: true
                    }
                }
            })
        }
    },

    getMessage: function() {
        return iget2(
            'b-banner-storage-frame',
            'are-you-sure-you-want-to-exit',
            'Вы уверены, что хотите выйти?'
        );
    },

    _onWidthChange: function(data) {
        this.setMod('width', data.width);
        this._modal.repaint();
    },

    /**
     * Получает с сервера информацию о выбранных креативах
     * @param {Object} data данные из конструктора
     * @param {Object} data.landingId id выбранного лендинга
     * @param {Function} onSuccess callback на удачное завершение запроса
     * @param {Function} onError callback на неудачное завершение запроса
     * @private
     */
    _ajaxSend: function(data, onSuccess, onError) {
        var request = BEM.create('i-request_type_ajax', {
            url: u.consts('SCRIPT'),
            dataType: 'json',
            type: 'POST',
            cache: false,
            timeout: this._ajaxTimeout
        });

        request.get({
            ulogin: u.consts('ulogin') || '',
            cmd: 'ajaxGetTurboLanding',
            id: data.landingId
        }, onSuccess, onError);
    },

    /**
     * Валидирует выбранные лендинги и генерирует событие сохранения
     * @param {Object} response - ответ от бэкенда с информацией о выбранных креативах
     * @private
     */
    _validateAndSave: function(response) {
        this.trigger('select', response.turbolanding);
        this.hide();

        BEM.blocks['b-metrika2'].params({
            params: {
                turbolandingConstructor: {
                    updated: true
                }
            }
        })
    }
});
