BEM.DOM.decl({
    block: 'b-banner-storage-frame',
    modName: 'type',
    modVal: 'video-creative',
    implements: 'i-modal-popup-inner-block-interface'
}, {

    /**
     * Показывает блок в модальном окне
     * @param {'creatives'|'presets'} type - вкладка, открытая по умолчанию (галерея/конструктор)
     * @param {Number} clientId - id клиента
     * @param {String} videoType
     * */
    show: function(type, clientId, videoType) {
        var sharedData;

        switch (videoType) {
            case 'cpm-outdoor':
                sharedData = u['b-banner-storage-frame'].getVideoSharedData(clientId, 'cpm_outdoor');
                break;
            case 'cpm-indoor':
                sharedData = u['b-banner-storage-frame'].getVideoSharedData(clientId, 'cpm_indoor');
                break;
            case 'cpm-audio':
                sharedData = u['b-banner-storage-frame'].getVideoSharedData(clientId, 'cpm_audio');
                break;
            default:
                sharedData = u['b-banner-storage-frame'].getVideoSharedData(clientId, 'cpm');
        }

        if (this._modal) {
            this._modal.show();
        }

        this._renderCanvasDna(sharedData, type === 'add' ? 'constructor' : type);
    },

    /**
     * Получает с сервера информацию о выбранных креативах
     * @param {Object} data данные из конструктора
     * @param {Function} onSuccess callback на удачное завершение запроса
     * @param {Function} onError callback на неудачное завершение запроса
     * @private
     */
    _ajaxSend: function(data, onSuccess, onError) {
        var request = BEM.create('i-request_type_ajax', {
            url: u.consts('SCRIPT'),
            dataType: 'json',
            type: 'POST',
            cache: false,
            timeout: this._ajaxTimeout
        });

        request.get({
            ulogin: u.consts('ulogin') || '',
            cmd: 'searchVideoCreatives',
            creative_id: data.creativeIds.join(',')
        }, onSuccess, onError);
    },

    /**
     * Валидирует выбранные креативы и генерирует событие сохранения
     * @param {Object} response - ответ от бэкенда с информацией о выбранных креативах
     * @private
     */
    _validateAndSave: function(response) {
        this.trigger('select', response.result.creatives);
        this.hide();
    }

});
