BEM.DOM.decl({ block: 'b-banner-storage-frame', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {

            this._btnReload = this.findBlockOn('error-action-reload', 'button');

            this._initEvents();
        }
    },

    /**
     * Показывает блок в модальном окне
     * @param {'creatives'|'presets'|''|'add'|'preview'} type - вкладка, открытая по умолчанию (галерея/конструктор)
     * @param {String} clientId - id клиента
     * @param {Object} validationRules - правила валидации выбранных креативов
     * @param {Number} validationRules.maxCount - максимальное разрешенное для выбора количество креативов
     * @param {Object} validationRules.single - разрешен выбор только одного креатива на замену сохраненному
     * @param {Number} validationRules.single.width - ширина сохраненного креатива (должна соответствовать)
     * @param {Number} validationRules.single.height - высота сохраненного креатива (должна соответствовать)
     * @param {Boolean} isHTML5 — флаг ли креатив HTML5 баннером (DIRECT-72386)
     * @param {String} [productType] — тип продукта HTML5 конструктора
     * @param {Boolean} isAdaptive — флаг для адаптивного креатива (ГО) https://st.yandex-team.ru/DIRECT-95868
     */
    show: function(type, clientId, validationRules, isHTML5, productType, isAdaptive) {
        var sharedData;

        this._validationRules = validationRules;
        this._clientId = clientId;
        this._isHTML5 = isHTML5;

        if (isAdaptive) {
            sharedData = u['b-banner-storage-frame'].getSharedData('adaptive', clientId, validationRules.single, { isAdaptive: true });
        } else {
            sharedData = u['b-banner-storage-frame'].getSharedData('common', clientId, validationRules.single);
        }

        if (this._modal) {
            this._modal.show();
        }

        if (this._isHTML5) {
            this._renderHtml5Dna(clientId, productType, type === 'add' ? 'upload' : 'active', validationRules.single);
        } else {
            this._renderCanvasDna(sharedData, isAdaptive ? 'constructor' : type);
        }
    },

    /**
     * Закрывает модальное окно с блоком
     */
    hide: function() {
        // `source: force` - это хак, для `b-modal-popup-decorator` (к которому тут нет доступа), чтобы
        // он при обработке события `before-hide` закрыл попап без предупреждения о наличии изменений
        this._modal && this._modal.hide({ source: 'force' });
    },

    getMessage: function() {
        return iget2(
            'b-banner-storage-frame',
            'unsaved-changes-will-be-lost',
            'Несохраненные изменения будут потеряны. Продолжить?'
        );
    },

    /**
     * Были ли изменения (реализация интерфейса i-modal-popup-inner-block-interface)
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        this._showMessage(
            this.getMessage(),
            'confirm',
            (function() { deferred.resolve(false); }).bind(this),
            (function() { deferred.resolve(true); }).bind(this)
        );

        return deferred;
    },

    _ajaxTimeout: 10000,

    /**
     * Обрабатывает сообщения, отправленные из iframe через postMessage
     * @param {Object} e - Информация о событии
     * @private
     */
    _onMessage: function(e) {
        var data = e.data || {};

        switch (data.type) {
            case 'error':
                this._onError(data);
                break;
            case 'close':
                this._onClose(data);
                break;
            case 'landings-select':
            case 'creatives-select':
                this._onCreativeSelect(data);
                break;
            case 'width-change':
                this._onWidthChange(data);
                break;
            case 'ready':
                this._onReady(data);
                break;
        }
    },

    /**
     * Обработчик события ошибки из iframe
     * @param {Object} data
     * @private
     */
    _onError: function(data) {
        this._showMessage(
            iget2(
                'b-banner-storage-frame',
                'servis-vremenno-nedostupen-try-later',
                'Сервис временно недоступен. Пожалуйста, повторите попытку позже.'
            ),
            'alert',
            this.hide
        );
    },

    /**
     * Обработчик события close из iframe
     * @param {Object} data
     * @private
     */
    _onClose: function(data) {
        this._showMessage(iget2(
            'b-banner-storage-frame',
            'unsaved-changes-will-be-lost',
            'Несохраненные изменения будут потеряны. Продолжить?'
        ), 'confirm', this.hide);
    },

    /**
     * Обработчик события ready из iframe
     * @param {Object} data
     * @private
     */
    _onReady: function(data) {
        // используется в модификаторе
    },

    /**
     * Обработчик события width-change из iframe
     * @param {Object} data
     * @private
     */
    _onWidthChange: function(data) {
        // используется в модификаторе
    },

    /**
     * Обработчик события выбора креатива из iframe
     * @param {Object} data
     * @private
     */
    _onCreativeSelect: function(data) {
        this._ajaxSend(
            data,
            this._validateAndSave.bind(this),
            function() {
                this._showMessage(
                    iget2(
                        'b-banner-storage-frame',
                        'servis-vremenno-nedostupen-try-later',
                        'Сервис временно недоступен. Пожалуйста, повторите попытку позже.'
                    ),
                    'alert',
                    this.hide
                );
            }.bind(this)
        );
    },

    _onCreativeSelectFromDna: function(creativeIds) {
        this._onCreativeSelect({
            clientId: this._clientId,
            creativeIds: creativeIds
        });
    },

    /**
     * Получает с сервера информацию о выбранных креативах
     * @param {Object} data данные из конструктора
     * @param {Function} onSuccess callback на удачное завершение запроса
     * @param {Function} onError callback на неудачное завершение запроса
     * @private
     */
    _ajaxSend: function(data, onSuccess, onError) {
        var request = BEM.create('i-request_type_ajax', {
            url: u.consts('SCRIPT'),
            dataType: 'json',
            type: 'POST',
            cache: false,
            timeout: this._ajaxTimeout
        });

        request.get({
            ulogin: u.consts('ulogin') || '',
            cmd: 'searchCanvasCreatives',
            creative_id: data.creativeIds.join(',')
        }, onSuccess, onError);
    },

    /**
     * Валидирует выбранные креативы и генерирует событие сохранения
     * @param {Object} response - ответ от сервера с информацией о выбранных креативах
     * @private
     */
    _validateAndSave: function(response) {
        var creatives = response.result.creatives,
            message = this._validate(creatives);

        if (message) {
            this._showMessage(message, 'alert', this._continue);
        } else {
            this.trigger('select', creatives);
            this.hide();
        }
    },

    /**
     * Валидирует выбранные креативы
     * @param {Array} creatives - список креативов
     * @returns {String} сообщение об ошибке
     * @private
     */
    _validate: function(creatives) {
        var rules = this._validationRules,
            msg;

        if (!creatives.length) {
            return iget2(
                'b-banner-storage-frame',
                'servis-vremenno-nedostupen-try-later',
                'Сервис временно недоступен. Пожалуйста, повторите попытку позже.'
            );
        }

        if (!rules) return;

        if (rules.single) {
            if (creatives.length !== 1) {
                return iget2(
                    'b-banner-storage-frame',
                    'pri-redaktirovanii-graficheskogo-obyavleniya',
                    'При редактировании графического объявления, можно выбрать только один креатив и только аналогичного размера.'
                );
            } else {
                if (rules.single === 'adaptive') {
                    if (creatives[0].is_adaptive !== '1') {
                        return iget2(
                            'b-banner-storage-frame',
                            'can-replace-adaptive-only',
                            'Можно заменить только на креатив того же размера (адаптивный)'
                        );
                    }
                } else if (
                    rules.single.width !== creatives[0].width ||
                    rules.single.height !== creatives[0].height ||
                    creatives[0].is_adaptive === '1'
                ) {
                    return iget2(
                        'b-banner-storage-frame',
                        'mozhno-zamenit-tolko-na',
                        'Можно заменить только на креатив того же размера ({foo}×{bar}).',
                        {
                            foo: rules.single.width,
                            bar: rules.single.height
                        }
                    );
                }
            }
        } else {
            if (rules.hasOwnProperty('maxCount')) {
                if (rules.maxCount < creatives.length) {

                    msg = rules.maxCount ?
                        u.pluralForms(iget2(
                            'b-banner-storage-frame',
                            'v-etu-gruppu-mozhno',
                            'В эту группу можно добавить не более {foo} {объявления|объявлений|объявлений}.',
                            {
                                foo: rules.maxCount
                            }
                        ), rules.maxCount) :
                        iget2(
                            'b-banner-storage-frame',
                            'dostignuto-ogranichenie-na-kolichestvo',
                            'Достигнуто ограничение на количество объявлений в группе.'
                        );

                    return msg + '<br/>' + iget2(
                        'b-banner-storage-frame',
                        'vyberite-menshee-kolichestvo-kreativov',
                        'Выберите меньшее количество креативов или создайте новую группу объявлений.'
                    );
                }
            }
        }
    },

    /**
     * Вызывает postMessage у iframe
     * @param {*} message - данные для отправки
     * @param {String} targetOrigin - разрешенный домен
     */
    postMessage: function(message, targetOrigin) {
        targetOrigin = targetOrigin || '*';
        this.elem('iframe').get(0).contentWindow.postMessage(message, targetOrigin);
    },

    /**
     * Отображает сообщение
     * @param {String} message - Текст сообщения об ошибке
     * @param {'alert'|'confirm'} type - Тип сообщения
     * @param {Function} cbYes - callback для кнопки "Да" ("Ок")
     * @param {Function} [cbNo] - callback для кнопки "Нет"
     * @private
     */
    _showMessage: function(message, type, cbYes, cbNo) {
        BEM.blocks['b-confirm'].open({
            message: message,
            type: type,
            fromPopup: this._modal,
            isAlertUnclosable: true,
            onYes: cbYes.bind(this),
            onNo: cbNo && cbNo.bind(this)
        });
    },

    /**
     * Отправляет в конструктор креативов сообщение 'unlock'
     * @private
     */
    _continue: function() {
        // описание формата общения с КК https://st.yandex-team.ru/MEDIAINTERFACES-1122#1469454459000
        if (this._isHTML5) {
            this._html5App.unlock();
        } else {
            this._canvasApp.unlock();
        }
    },

    /**
     * Загружает в iframe нужную вкладку конструктора креативов
     * @param {String} constructorUrl - адрес КК
     * @param {String} [pingUrl] - адрес для проверки доступности КК
     * @private
     */
    _loadConstructor: function(constructorUrl, pingUrl) {
        pingUrl = pingUrl || u['b-banner-storage-frame'].getPingUrl();

        this.setMod('loading', 'yes');

        BEM.create('i-request_type_ajax', {
            url: pingUrl,
            dataType: 'html',
            type: 'GET',
            cache: false,
            timeout: this._ajaxTimeout
        }).get({}, (function() {
            this.elem('iframe').attr('src', constructorUrl);
        }).bind(this), (function() {
            this.setMod('loading', 'error');
        }).bind(this));
    },

    /**
     * Повторная попытка загрузки КК
     * @private
     */
    _reloadIframe: function() {
        this._canvasUrl && this._loadConstructor(this._canvasUrl);
    },

    /**
     * Запоминает модальное окно, в котором открыт КК
     * @param {Object} modal
     * @private
     */
    // todo@dima117a: вынести modal в отдельный родительский блок и генерировать для него события
    _setModal: function(modal) {
        this._modal && this._modal.un('hide');

        this._modal = modal;

        this._modal.on('hide', function() {
            this.trigger('close');
        }, this);
    },

    /**
     * Добавляет обработчики событий
     * @private
     */
    _initEvents: function() {
        this._messageHandler = this._onMessage.bind(this);

        window.addEventListener('message', this._messageHandler, false);

        this.elem('iframe').on('load', (function() {
            this.delMod('loading');
        }).bind(this));

        this._btnReload.on('click', this._reloadIframe, this);
    },

    destruct: function() {
        window.removeEventListener('message', this._messageHandler, false);
        this.elem('iframe').off('load');

        this._btnReload.un('click');

        if (this._modal) {
            this._modal.un('hide');
            this._modal.destruct();
        }

        this.__base.apply(this, arguments);
    },

    _renderHtml5Dna: function(clientId, productType, page, filterBySize) {
        var dna = window.dna,
            html5App = dna.reactCreateElement(
            dna.components.Html5App,
                {
                    sharedData: {
                        clientId: clientId,
                        productType: productType,
                        filters: filterBySize ?
                            { sizes: [{ w: filterBySize.width, h: filterBySize.height }] } :
                            undefined
                    },
                    page: page,
                    onClose: this._onClose.bind(this),
                    onCreativesSelect: this._onCreativeSelectFromDna.bind(this)
                },
                null,
                {
                    disableBaobab: true
                }
        );

        return new Promise(function(resolve) {
            dna.reactDOMRender(
                html5App,
                this.blockInside('b-banner-storage-frame').domElem.get(0),
                function() {
                    resolve(this);
                }
            );
        }.bind(this)).then(function(dnaComponent) {
            this._html5App = dnaComponent;
        }.bind(this));
    },

    /**
     * Встраивает компонент конструктора
     * @param {Object} sharedData - Данные для открытия конструктора
     * @param {'presets'|'creatives'|'constructor'} page - Страница конструктора
     * @param {String} [creativeId] - id креатива для страницы создания на основе
     * @private
     */
    _renderCanvasDna: function(sharedData, page, creativeId) {
        var dna = window.dna,
            videoPreviewData = this.__self.getVideoPreviewData(),
            canvasApp = dna.reactCreateElement(
                dna.components.CanvasApp,
                {
                    sharedData: sharedData,
                    page: page,
                    onClose: this._onClose.bind(this),
                    onCreativesSelect: this._onCreativeSelectFromDna.bind(this),
                    videoPreviewData: videoPreviewData,
                    tld: u.consts('tld'),
                    cspNonce: BEM.blocks['i-global'].param('nonce'),
                    creativeId: creativeId,
                    isCanvasRangeRatioCpcEnabled: u.consts('isCanvasRangeRatioCpcEnabled')
                },
                null
            );

        return new Promise(function(resolve) {
            dna.reactDOMRender(
                canvasApp,
                this.blockInside('b-banner-storage-frame').domElem.get(0),
                function() {
                    resolve(this);
                }
            );
        }.bind(this)).then(function(dnaComponent) {
            this._canvasApp = dnaComponent;
        }.bind(this));
    },
}, {
    /**
     * Создаёт блок загрузки файла по ссылке в модальном окне
     * @returns {BEM.DOM<b-banner-storage-frame>}
     */
    create: function(mods, videoPreviewData) {
        var modal = BEM.DOM.blocks['b-modal-popup-decorator'].create2(null, { hasClose: true, bodyScroll: false }, $),
            uploader = modal.setPopupContent({ block: 'b-banner-storage-frame', mods: mods });
        this._videoPreviewData = videoPreviewData;

        uploader._setModal(modal.domElem.bem('popup'));

        return uploader;
    },

    getVideoPreviewData: function() {
        return this._videoPreviewData;
    }
});
