u.register({
    'b-banner-storage-frame': {

        /**
         * Формирует данные для открытия Конструктора графических креативов
         * @param {'common'|'adaptive'} creativeType - тип креатива
         * @param {String} clientId - id клиента
         * @param {Object | String} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @param {Object} [additionalParams] - допольнительные свойства
         * @return {*}
         */
        getSharedData: function(creativeType, clientId, filterBySize, additionalParams) {
            var sharedData = {
                creativeType: creativeType,
                clientId: clientId,
                filters: filterBySize ?
                { sizes: [
                    filterBySize === 'adaptive' ?
                    filterBySize :
                    { w: filterBySize.width, h: filterBySize.height }
                ] } :
                undefined,
                areFiltersDisabled: !!filterBySize
            };

            return additionalParams ? Object.assign(sharedData, additionalParams) : sharedData;
        },

        /**
         * Формирует данные для открытия Конструктора видео креативов
         * @param {Number} clientId - id клиента
         * @param {String} [groupType] - тип группы
         * @return {*}
         */
        getVideoSharedData: function(clientId, groupType) {
            var sharedData = {
                creativeType: 'videoAddition',
                clientId: clientId
            };

            // Выставляем флаг "1" для полученного типа группы
            // Нужно для видео-дополнений в РМП и ТГО (DIRECT-85572)
            if (groupType) {
                sharedData[groupType] = 1;
            }

            return sharedData;
        },

        /**
         * Формирует адрес для открытия Конструктора креативов в iframe
         * @param {'creatives'|'presets'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @param {Object | String} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @return {String}
         */
        getUrl: function(type, clientId, filterBySize) {
            // формат параметров КК https://st.yandex-team.ru/DIRECT-59739#1477065220000
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    filters: filterBySize ?
                    { sizes: [
                        filterBySize === 'adaptive' ?
                        filterBySize :
                        { w: filterBySize.width, h: filterBySize.height }
                    ] } :
                    undefined,
                    areFiltersDisabled: !!filterBySize
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type,
                query: {
                    client_id: clientId,
                    compact: 1,
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора HTML5 креативов в iframe
         * @param {''|'add'|'preview'} type - загруизть/выбрать из ранее загруженных/превью
         * @param {Number} clientId - id клиента
         * @param {Object} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @param {String} [productType] - тип продукта HTML5 конструктора
         * @return {String}
         */
        getHtml5Url: function(type, clientId, filterBySize, productType) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    filters: filterBySize ?
                        { sizes: [{ w: filterBySize.width, h: filterBySize.height }] } :
                        undefined,
                    areFiltersDisabled: !!filterBySize,
                    productType: productType
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: 'html5/' + type,
                query: {
                    compact: 1,
                    creativeType: 'html5',
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора видео креативов в iframe
         * @param {'add'|'creatives'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @return {*}
         */
        getVideoCreativeUrl: function(type, clientId) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    creativeType: 'videoAddition',
                    cpm: 1
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'add' ? '/presets/6/creatives/add' : type,
                query: {
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора аудиокреативов в iframe
         * @param {'add'|'creatives'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @return {*}
         */
        getAudioCreativeUrl: function(type, clientId) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    creativeType: 'videoAddition',
                    cpm_audio: 1
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'add' ? '/presets/301/creatives/add' : type,
                query: {
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора видео креативов в iframe
         * @param {'add'|'creatives'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @return {*}
         */
        getVideoOutdoorCreativeUrl: function(type, clientId) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    creativeType: 'videoAddition',
                    cpm_outdoor: 1
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'add' ? '/presets/101/creatives/add' : type,
                query: {
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора видео креативов в iframe
         * @param {'add'|'creatives'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @return {*}
         */
        getVideoIndoorCreativeUrl: function(type, clientId) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    creativeType: 'videoAddition',
                    cpm_indoor: 1
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'add' ? '/presets/201/creatives/add' : type,
                query: {
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора видео креативов в iframe
         * @param {'creatives'|'presets'| 'edit'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @param {Object} [extraParams] - дополнительные параметры
         * @param {Number} [extraParams.creativeId] - id креатива
         * @param {String} [extraParams.groupType] - тип группы
         * @return {*}
         */
        getVideoUrl: function(type, clientId, extraParams) {
            var params = {
                isCompact: true,
                clientId: clientId,
                creativeType: 'videoAddition'
            };

            // Выставляем флаг "1" для полученного типа группы
            // Нужно для видео-дополнений в РМП и ТГО (DIRECT-85572)
            if (extraParams.groupType) {
                params[extraParams.groupType] = 1;
            }

            if (type === 'edit') {
                type = '/video-additions/creatives/' + extraParams.creativeId + '/add';
            }

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type,
                query: {
                    shared_data: encodeURIComponent(JSON.stringify(params)),
                    creative_id: u._.get(extraParams, 'creativeId')
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора видео креативов в iframe
         * @param {'creatives'|'presets'| 'edit'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @param {Object} [extraParams] - дополнительные параметры
         * @param {Number} [extraParams.creativeId] - id креатива
         * @return {*}
         */
        getCpcVideoUrl: function(type, clientId, extraParams) {
            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'edit' ?
                    '/video-additions/creatives/' + extraParams.creativeId + '/add' :
                    type,
                query: {
                    shared_data: encodeURIComponent(
                        JSON.stringify({
                            isCompact: true,
                            clientId: clientId,
                            creativeType: 'videoAddition',
                            cpc: 1
                        })
                    ),
                    creative_id: u._.get(extraParams, 'creativeId')
                }
            });
        },

        getMobileContentVideoUrl: function(type, clientId, extraParams) {
            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'edit' ?
                    '/video-additions/creatives/' + extraParams.creativeId + '/add' :
                    type,
                query: {
                    shared_data: encodeURIComponent(
                        JSON.stringify({
                            isCompact: true,
                            clientId: clientId,
                            creativeType: 'videoAddition',
                            mobile_content_video: 1
                        })
                    ),
                    creative_id: u._.get(extraParams, 'creativeId')
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора трубо-страниц в iframe
         * @param {Number} clientId - id клиента
         * @param {Number} selectedId - id выбранной турбо-страницы
         * @param {Boolean} userHasSite - флаг, есть ли у пользователя сайт или турбо - основная страница
         * @param {Object} additionalParams - объект с дополнительными параметрами
         * @param {String} additionalParams.templateName - имя шаблона, с которым нужно открыть Конструктор
         * @param {Array} additionalParams.enableTemplates - массив white-list шаблонов
         * @return {String}
         */
        getTurboLandingsUrl: function(clientId, selectedId, userHasSite, additionalParams) {
            var id = +selectedId || undefined, // фильтруем кривые id вроде '0'
                host = u.consts('turboUiUrl'),
                lang = this.getTurboConstructorLang(),
                wizardPath = '/wizard/short-preset/' + lang,
                path = additionalParams.creationMode === 'wizard' ? wizardPath : '/',
                params = u._.extend({}, {
                    clientId: clientId,
                    creativeType: 'common',
                    isCompact: true,
                    filters: { sizes: [] },
                    areFiltersDisabled: false,
                    selected_id: id,
                    mode: 'select',
                    platform: userHasSite ? 'phone' : 'desktop'
                }, additionalParams);

            return u.formatUrl({
                host: host,
                path: path,
                query: {
                    shared_data: encodeURIComponent(JSON.stringify(params))
                }
            });
        },

        getTurboConstructorLang: function() {
            var lang = u.consts('lang');

            if (lang === 'en' || lang === 'tr') {
                return 'en';
            }
            return 'ru';
        },

        /**
         * Формирует адрес для проверки работоспособности Конструктора трубо-страниц
         * @returns {String}
         */
        getTurboPingUrl: function() {
            if (u.consts('isUnifiedTurbo')) {
                return u.formatUrl({
                    host: u.consts('turboUiUrl'),
                    path: 'api/ping'
                });
            }

            return this.getPingUrl();
        },

        /**
         * Формирует адрес для проверки работоспособности Конструктора креативов
         * @returns {String}
         */
        getPingUrl: function() {
            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: 'ping'
            });
        },

        /**
         * Формирует адрес для открытия Конструктора креативов (баннеры для Яндекс.Метро) в iframe
         * @param {'creatives'|'presets'} type - начальная вкладка (галерея готовых/создание нового креатива)
         * @param {Number} clientId - id клиента
         * @param {Object} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @return {String}
         */
        getGeoProductCanvasUrl: function(type, clientId, filterBySize) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    filters: filterBySize ?
                        { sizes: [{ w: filterBySize.width, h: filterBySize.height }] } :
                        undefined,
                    areFiltersDisabled: !!filterBySize,
                    cpm_geoproduct: 1,
                    creativeType: 'cpmGeoproduct'
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: type === 'presets' ? type + '/10/creatives/add' : type,
                query: {
                    client_id: clientId,
                    compact: 1,
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия Конструктора HTML5 креативов в iframe
         * @param {''|'add'|'preview'} type - загруизть/выбрать из ранее загруженных/превью
         * @param {Number} clientId - id клиента
         * @param {Object} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @param {String} [productType] - тип продукта HTML5 конструктора
         * @return {String}
         */
        getGeoProductHtml5Url: function(type, clientId, filterBySize, productType) {
            var params = encodeURIComponent(
                JSON.stringify({
                    isCompact: true,
                    clientId: clientId,
                    filters: filterBySize ?
                        { sizes: [{ w: filterBySize.width, h: filterBySize.height }] } :
                        undefined,
                    areFiltersDisabled: !!filterBySize,
                    productType: productType
                })
            );

            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: 'html5/' + type,
                query: {
                    compact: 1,
                    creativeType: 'html5',
                    shared_data: params
                }
            });
        },

        /**
         * Формирует адрес для открытия шаблона Адаптивного ГО в Конструкторе креативов
         * @param {String} clientId - id клиента
         * @param {Object | String} [filterBySize] - фильтр креативов по размеру
         * @param {Number} [filterBySize.width] - фильтр по длине
         * @param {Number} [filterBySize.height] - фильтр по высоте
         * @return {String}
         */
        getAdaptiveUrl: function(clientId, filterBySize) {
            return u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: 'presets/5/creatives/add',
                query: {
                    client_id: clientId,
                    compact: 1,
                    shared_data: encodeURIComponent(
                        JSON.stringify({
                            isCompact: true,
                            clientId: clientId,
                            isAdaptive: true,
                            creativeType: 'adaptive',
                            filters: filterBySize ?
                                { sizes: [
                                    filterBySize === 'adaptive' ?
                                        filterBySize :
                                        { w: filterBySize.width, h: filterBySize.height }
                                ] } :
                                undefined,
                            areFiltersDisabled: !!filterBySize,
                        })
                    )
                }
            });
        }
    }
});
