BEM.DOM.decl('b-banner-viewer', {

    onSetMod: {

        js: function() {
            var bannerModel = this._getModelBanner();

            //у РМП-баннеров нет image_model
            bannerModel.hasField('image_model') && bannerModel.on('image_model', 'change', this._onImageChange, this);
            bannerModel.hasField('sitelinks') && bannerModel.on('sitelinks', 'change', this._onSitelinksChange, this);
        },

        'current-view': function(modName, modVal) {
            this._getBannerPreview().setMod('view', modVal);
        }

    },

    /**
     * Показать в попапе страницу всех видов РСЯ
     * @param {AllFormatsOptions} [options] дополнительные опции
     */
    showBannerAllFormats: function(options) {
        var previewBlock = this._getBannerPreview(),
            bannerData = previewBlock.getDM('banner').toJSON(),
            bannerPcodeData = u['b-banner-preview2'].getDataToPcode(previewBlock);

        this._getBannerPreviewFilter()
            .showBannerAllFormats(options, {
                mediaType: this._getCampaignModel().get('mediaType'),
                bannerData: bannerData,
                bannerPcodeData: bannerPcodeData
            });
    },

    /**
     * Возвращает модель кампании
     * @returns {BEM.MODEL}
     */
    _getCampaignModel: function() {
        return this._campaignModel || (this._campaignModel = BEM.MODEL.getOrCreate(this.params.modelCampaignParams));
    },

    /**
     * Возвращает модель баннера
     * @returns {BEM.MODEL}
     */
    _getModelBanner: function() {
        return this._modelBanner || (this._modelBanner = BEM.MODEL.getOrCreate(this.params.modelBannerParams));
    },

    /**
     * Обработчик на добавление/удаление картинки в баннере
     * @param {jQuery.Event} e
     * @private
     */
    _onImageChange: function(e) {
        var filterDomElem = this.findElem('filter'),
            filter = this._getBannerPreviewFilter(filterDomElem),
            currentValue = filter.val(),
            campModel = this._getCampaignModel(),
            campMediaType = campModel.get('mediaType'),
            banners = [
                u._.pick(this._getModelBanner().provideData(), ['image', 'creative', 'banner_type', 'sitelinks'])
            ],
            imageModel = e.target.get('image_model'),
            imageIsDeleted = !imageModel.get('image') && imageModel.get('image_processing_state') != 'pending',
            isMobileContent = campMediaType == 'mobile_content',
            // если удаляем картинку, а в текущий вид превью В сетях
            needReset = imageIsDeleted && isMobileContent && currentValue.type === 'context',
            tabList = u['b-banner-preview-filter2'].getTabsList({
                strategySearchName: campModel.get('strategy').search.name,
                dontShowYacontext: campModel.get('dontShowYacontext'),
                campMediaType: campModel.get('mediaType'),
                banners: banners
            }),
            isPartnerAllFormatsEnabled = u['b-banner-preview-filter2'].isPartnerAllFormatsEnabled({
                campMediaType: campMediaType,
                banners: banners
            });

        if (needReset) {
            // сначала ищем таб по умолчанию
            currentValue = u._.find(tabList, { isDefault: true });

            // если не нашли, то не очень красиво переключаем вид в базовый
            currentValue || (currentValue = tabList[0]);

            typeof currentValue == 'string' && (currentValue = { type: currentValue });
        }

        BEM.DOM.replace(filterDomElem, $(BEMHTML.apply({
            block: 'b-banner-preview-filter2',
            mix: [{
                block: 'b-banner-viewer',
                elem: 'filter'
            }],
            tabList: tabList,
            currentTab: currentValue,
            isPartnerAllFormatsEnabled: isPartnerAllFormatsEnabled
        })));

        needReset && this._onChangeView(currentValue);
    },

    /**
     * Обработчик изменения быстрых ссылок в объявлении
     * @param {jQuery.Event} e
     * @private
     */
    _onSitelinksChange: function(e) {
        var filterDomElem = this.findElem('filter'),
            filter = this._getBannerPreviewFilter(filterDomElem),
            currentValue = filter.val(),
            campModel = this._getCampaignModel(),
            campMediaType = campModel.get('mediaType'),
            banners = [
                u._.pick(this._getModelBanner().provideData(), ['image', 'creative', 'banner_type', 'sitelinks'])
            ];

        BEM.DOM.replace(filterDomElem, $(BEMHTML.apply({
            block: 'b-banner-preview-filter2',
            mix: [{
                block: 'b-banner-viewer',
                elem: 'filter'
            }],
            tabList: u['b-banner-preview-filter2'].getTabsList({
                strategySearchName: campModel.get('strategy').search.name,
                dontShowYacontext: campModel.get('dontShowYacontext'),
                campMediaType: campMediaType,
                banners: banners
            }),
            isPartnerAllFormatsEnabled: u['b-banner-preview-filter2'].isPartnerAllFormatsEnabled({
                campMediaType: campMediaType,
                banners: banners
            }),
            currentTab: currentValue
        })));

        this._onChangeView(currentValue);
    },

    /**
     * Обработчик на изменения вида превью
     * @param {BannerPreviewFilterState} value
     * @private
     */
    _onChangeView: function(value) {
        this.setMod('current-view', this._calcModValBannerPreview(value));
    },

    /**
     * Возвращает объект соответствия значения блока b-banner-preview-filter2 значению модификатора view у b-banner-preview2
     * @param {BannerPreviewFilterState} data
     * @returns {Object}
     * @private
     */
    _calcModValBannerPreview: function(data) {
        var campMediaType = this._getCampaignModel().get('mediaType'),
            defaultRedifinition = {
                base: 'edit',
                context: 'partner'
            },
            redefinition = {
                mobile_content: {
                    base: 'mobile-content-edit',
                    search: 'mobile-content-search',
                    context: 'mobile-content-partner-poster'
                }
            }[campMediaType] || defaultRedifinition;

        return data ?
            [
                redefinition[data.type] || data.type,
                data.device,
                data.target ? 'target' : false
            ].filter(Boolean).join('-') :
            '';
    },

    /**
     * Возвращает экземпляр блока `b-banner-preview2`
     * @returns {BEM.DOM}
     * @private
     */
    _getBannerPreview: function() {
        return this._bannerPreview || (this._bannerPreview = this.findBlockInside('b-banner-preview2'));
    },

    /**
     * Возвращает блок переключения видов
     * @param {jQuery} [filterDomElem] DOM-нода фильтра
     * @private
     */
    _getBannerPreviewFilter: function(filterDomElem) {
        // не кэшируем, т.к. фильтр перерисовывается
        return this.findBlockOn(filterDomElem || this.findElem('filter'), 'b-banner-preview-filter2');
    },

    destruct: function() {
        var bannerModel = this._getModelBanner();

        if (bannerModel.hasField('image_model')) {
            this._getModelBanner()
                .un('image_model', 'change', this._onImageChange, this);
        }

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'b-banner-preview-filter2', function(e, data) {
                this._onChangeView(data.value);
            })
            .liveInitOnBlockInsideEvent('banner-all-formats-button:click', 'b-banner-preview-filter2',
                function() {
                    var campModel = this._getCampaignModel();

                    this.showBannerAllFormats({
                        clientId: campModel.get('ClientID')
                    });
                });

        // так как подписываемся на модель
        return false;
    }

});
