block('b-banners-per-page')(

    js()(function() {
        return {
            urlObject: this.ctx.urlObject,
            tag: this.ctx.ctag,
            tab: this.ctx.tab,
            optimalGroupsOnPage: this.ctx.optimalGroupsOnPage
        };
    }),

    content()(function() {
        return [
            {
                elem: 'title',
                content: this.ctx.title
            },
            {
                elem: 'buttons',
                content: {
                    block: 'radio-button',
                    value: this.ctx.groupsOnPage + '',
                    content: this.ctx.pages.map(function(perPage) {
                        return {
                            elem: 'radio',
                            controlAttrs: { value: perPage + '' },
                            elemMods: { disabled: this.ctx.disabled ? 'yes' : undefined },
                            content: perPage
                        }
                    }, this)
                }
            }
        ];
    }),

    elem('title').tag()('span')
);
