block('b-banners-per-page').def()(function() {
    var ctx = this.ctx,
        data = this.data,
        campaign = data.campaign,
        pages = [5, 10, 20, 30, 50, 100, 200];

    ctx.disabled = data.login_rights.role === 'superreader';
    ctx.groupsOnPage = campaign.groups_on_page || data.banners_on_page;
    ctx.optimalGroupsOnPage = data.optimal_groups_on_page || data.optimal_banners_on_page;

    data.FORM.tag && (ctx.ctag = data.FORM.tag);
    data.FORM.tab && (ctx.tab = data.FORM.tab);

    ctx.urlObject = u.parseUrl(data.script);
    ctx.urlObject.query = this.extend(ctx.urlObject.query || {}, withUidPar({
        cmd: 'setPageSize',
        subcmd: data.FORM.cmd,
        cid: campaign.cid
    }));

    ctx.title = ctx.title ||
        ((campaign.mediaType == 'mcbanner' || campaign.mediaType == 'performance' ?
            iget2('b-banners-per-page', 'bannerov-na-stranice', 'Баннеров на странице') :
            iget2('b-banners-per-page', 'obyavleniy-na-stranice', 'Объявлений на странице')) +
        ': ');

    if (pages.indexOf(ctx.optimalGroupsOnPage) === -1) {
        pages.unshift(ctx.optimalGroupsOnPage);
    }

    ctx.pages = ctx.pages || pages.sort(function(a, b) {
        return a - b;
    });

    return applyNext();
});
