block('b-banners-search-banner').mod('type', 'cpm-price')(

    js()(function() {
        return {
            modelParams: {
                name: 'dm-cpm-price-banner',
                id: this.ctx.banner.bid,
                parentId: this.ctx.group.adgroup_id,
                parentName: 'dm-cpm-price-banner-group'
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            campaign = ctx.campaign,
            banner = ctx.banner,
            group = ctx.group,
            type = 'cpm_price',
            viewType = 'search-image',
            scriptUrlObject = u.consts('SCRIPT_OBJECT'),
            bannerUrl = u.formatUrl({
                protocol: scriptUrlObject.protocol,
                host: scriptUrlObject.host,
                path: '/dna/grid/banners',
                query: {
                    ulogin: banner.login,
                    'campaigns-ids': campaign.cid,
                    'groups-ids': group.adgroup_id
                }
            }),
            bannerData = u[u['b-banner-preview2'].getNameByType(type, viewType)].fromServer({
                banner: banner,
                group: group,
                campaign: campaign
            });

        if (!banner.creative) return;

        return {
            block: 'b-banner-preview2',
            mods: {
                type: u.beminize(type),
                view: viewType
            },
            data: u._.extend(
                bannerData, {
                    // ссылка с поиска должна вести на страницу кампании
                    customTitleUrl: bannerUrl,
                    // фикс для банеров с расхлопом, превью которого состоит из склеенных скриншотов двух блоков:
                    // основного и раскрывающегося, а в базе хранится размер скриншота основного блока.
                    isAdaptiveHeight: true
                }),
            modelsParams: {
                dmsIds: {
                    bannerId: banner.bid,
                    groupId: group.adgroup_id
                }
            }
        };
    })
);
