block('b-banners-search-banner').mod('type', 'dynamic')(

    js()(function() {
        return {
            modelParams: {
                name: 'dm-dynamic-group',
                id: this.ctx.banner.bid,
                parentId: this.ctx.group.adgroup_id,
                parentName: 'dm-dynamic-group'
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            campaign = ctx.campaign,
            banner = ctx.banner,
            group = ctx.group,
            type = 'dynamic',
            viewType = banner.ad_type === 'image_ad' ? 'search-image' : 'base',
            bannerUrl = u.formatUrl({
                host: ctx.script_for_show,
                query: {
                    cmd: 'showCamp',
                    cid: banner.cid,
                    ulogin: banner.login,
                    search_by: 'num',
                    search_banner: banner.bid,
                    tab: 'all'
                }
            }),
            bannerData = u[u['b-banner-preview2'].getNameByType(type, viewType)].fromServer({
                banner: banner,
                group: group,
                campaign: campaign
            });

        if (!banner.title && !banner.body && !banner.alt) return;

        if (banner.alt) return {
            block: 'link',
            mix: [{
                block: 'b-banners-search-banner',
                elem: 'alt'
            }],
            url: bannerUrl,
            content: banner.alt
        };

        return {
            block: 'b-banner-preview2',
            mods: {
                type: u.beminize(type),
                view: viewType
            },

            data: u._.extend(
                bannerData, {
                    // ссылка с поиска должна вести на страницу кампании
                    customTitleUrl: bannerUrl
                }),
            modelsParams: {
                dmsIds: {
                    bannerId: banner.bid,
                    groupId: group.adgroup_id
                }
            }
        };
    })
);
