block('b-banners-search-banner').mod('type', 'mobile-content')(
    js()(function() {
        return {
            modelParams: {
                id: this.ctx.banner.bid,
                name: 'dm-mobile-content-banner',
                parentId: this.ctx.group.adgroup_id,
                parentName: 'dm-mobile-content-group'
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            banner = ctx.banner,
            group = ctx.group,
            type = 'mobile_content',
            viewType = banner.ad_type === 'image_ad' ? 'search-image' : 'mobile-content-search',
            bannerUrl = u.formatUrl({
                host: ctx.script_for_show,
                query: {
                    cmd: 'showCamp',
                    cid: banner.cid,
                    ulogin: banner.login,
                    search_by: 'num',
                    search_banner: banner.bid,
                    tab: 'all'
                }
            }),
            bannerData = u[u['b-banner-preview2'].getNameByType(type, viewType)].fromServer({
                banner: banner,
                campaign: {},
                phrase: {},
                mobileContent: banner.mobile_content,
                group: banner
            });

        if (!banner.title && !banner.body && !banner.alt) return;

        if (banner.alt) {
            return {
                block: 'link',
                mix: [{
                    block: 'b-banners-search-banner',
                    elem: 'alt'
                }],
                url: bannerUrl,
                content: banner.alt
            };
        }

        return {
            block: 'b-banner-preview2',
            mods: {
                type: u.beminize(type),
                view: viewType,
                readonly: 'yes'
            },
            data: u._.extend(
                bannerData,
                {
                    // ссылка с поиска должна вести на страницу кампании
                    customTitleUrl: bannerUrl
                }
            ),
            modelsParams: {
                dmsIds: { bannerId: banner.bid, groupId: group.adgroup_id }
            }
        }
    })
);
