block('b-banners-search-banner').mod('type', 'performance')(
    js()(function() {
        return {
            modelParams: {
                id: this.ctx.banner.bid,
                name: 'dm-dynamic-media-banner',
                parentId: this.ctx.group.adgroup_id,
                parentName: 'dm-dynamic-media-group'
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            group = ctx.group,
            banner = ctx.banner;

        if (!banner.title && !banner.body && !banner.alt) return;

        if (banner.alt) return {
            block: 'link',
            mix: [{
                block: 'b-banners-search-banner',
                elem: 'alt'
            }],
            url: u.formatUrl({
                host: ctx.script_for_show,
                query: {
                    cmd: 'showCamp',
                    cid: banner.cid,
                    ulogin: banner.login,
                    search_by: 'num',
                    search_banner: banner.bid,
                    tab: 'all'
                }
            }),
            content: banner.alt
        };

        return {
            block: 'b-banner-preview2',
            mods: {
                view: 'performance-banners-search',
                type: 'performance'
            },
            data: {
                bid: banner.bid,
                creative: banner.creative,
                url: u.formatUrl({
                    host: ctx.script_for_show,
                    query: {
                        cmd: 'showCamp',
                        cid: banner.cid,
                        ulogin: banner.login,
                        search_by: 'num',
                        search_banner: banner.bid,
                        tab: 'all'
                    }
                })
            },
            modelsParams: {
                dmsIds: { bannerId: banner.bid, groupId: group.adgroup_id }
            }
        };
    })
);
