block('b-banners-search-banner').mod('type', 'text')(

    js()(function() {
        return {
            modelParams: {
                name: 'm-banner',
                id: this.ctx.banner.bid,
                parentId: this.ctx.group.adgroup_id,
                parentName: 'm-group'
            }
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            campaign = ctx.campaign,
            banner = ctx.banner,
            group = ctx.group,
            organization = ctx.organization,
            type = 'text',
            adType = banner.ad_type,
            viewType = adType === 'image_ad' ?
                'search-image' :
                adType === 'cpc_video' ?
                    'creative' :
                    'base',
            bannerUrl = u.formatUrl({
                host: ctx.script_for_show,
                query: {
                    cmd: 'showCamp',
                    cid: banner.cid,
                    ulogin: banner.login,
                    search_by: 'num',
                    search_banner: banner.bid,
                    tab: 'all'
                }
            }),
            bannerData = u[u['b-banner-preview2'].getNameByType(type, viewType)].fromServer({
                // cyn@TODO: оторвать когда creative начнет приходить
                banner: adType === 'cpc_video' && !banner.creative ?
                    u._.extend({}, banner, { creative: banner.video_resources }) :
                    banner,
                group: group,
                campaign: campaign,
                organization: organization
            });

        if (!(banner.alt || (adType === 'text' ? (banner.title || banner.body) : !!adType))) {
            return;
        }

        if (banner.alt) return {
            block: 'link',
            mix: [{
                block: 'b-banners-search-banner',
                elem: 'alt'
            }],
            url: bannerUrl,
            content: banner.alt
        };

        return {
            block: 'b-banner-preview2',
            mods: {
                type: u.beminize(type),
                view: viewType
            },

            data: u._.extend(
                bannerData, {
                    // ссылка с поиска должна вести на страницу кампании
                    customTitleUrl: bannerUrl
                }),
            modelsParams: {
                dmsIds: {
                    bannerId: banner.bid,
                    groupId: group.adgroup_id
                }
            },
            js: {
                hasOrganization: !!organization,
                preferVcardOverPermalink: banner.prefer_vcard_over_permalink
            }
        };
    })
);
