block('b-banners-search-form').elem('strategy-choose')(

    def()(function() {

        return applyNext({
            'ctx.strategyOptions': [
                {
                    name: iget2('b-banners-search-form', 'ne-uchityvat', 'Не учитывать'),
                    value: ''
                },
                {
                    name: iget2('b-banners-search-form', 'naivysshaya-dostupnaya-poziciya', 'Наивысшая доступная позиция'),
                    value: 'default'
                },
                {
                    name: iget2('b-banners-search-form', 'nezavisimoe-upravlenie-dlya-raznyh', 'Независимое управление для разных типов площадок'),
                    value: 'different_places'
                },
                {
                    name: iget2(
                        'b-banners-search-form',
                        'nedelnyy-byudzhet-maksimalnoe-kolichestvo',
                        'Недельный бюджет (максимальное количество кликов)'
                    ),
                    value: 'week_autobudget_avg_click'
                },
                {
                    name: iget2('b-banners-search-form', 'nedelnyy-byudzhet-maksimalnaya-konversiya', 'Недельный бюджет (максимальная конверсия)'),
                    value: 'week_autobudget_avg_cpa'
                },
                {
                    name: iget2('b-banners-search-form', 'srednyaya-cena-klika', 'Средняя цена клика'),
                    value: 'autobudget_avg_click'
                },
                {
                    name: iget2('b-banners-search-form', 'srednyaya-cena-konversii', 'Средняя цена конверсии'),
                    value: 'autobudget_avg_cpa'
                },
                {
                    name: iget2('b-banners-search-form', 'nedelnyy-paket-klikov', 'Недельный пакет кликов'),
                    value: 'autobudget_week_bundle'
                },
                {
                    name: iget2('b-banners-search-form', 'srednyaya-rentabelnost-investiciy-roi', 'Средняя рентабельность инвестиций (ROI)'),
                    value: 'autobudget_roi'
                }
            ]
        });
    }),

    content()(function() {
        var strategyOptions = this.ctx.strategyOptions,
            selectedStrategy = this.ctx.selectedStrategy;

        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'strategiya', 'Стратегия') + ':'
                },
                {
                    block: 'select',
                    mix: [{
                        block: 'b-banners-search-form',
                        elem: 'strategy-select'
                    }],
                    name: 'strategy',
                    content: [
                        {
                            block: 'button'
                        },
                        {
                            elem: 'control',
                            content: strategyOptions.map(function(option) {
                                var value = option.value,
                                    selected;

                                if (selectedStrategy === value) {
                                    selected = 'selected';
                                }

                                return {
                                    elem: 'option',
                                    attrs: {
                                        selected: selected,
                                        value: value
                                    },
                                    content: option.name
                                }
                            })
                        }
                    ]
                }
            ]
        };
    })
);
