block('b-banners-search-form').mod('type', 'agency')(

    elem('rows').content()(function() {
        return [
            {
                elem: 'hiddenInput',
                name: 'cmd',
                val: 'searchBanners'
            },
            {
                elem: 'hiddenInput',
                name: 'reverse',
                val: this.ctx.data.reverse || 1
            },
            {
                elem: 'hiddenInput',
                name: 'sort',
                val: this.ctx.data.sort || 'price'
            },
            {
                elem: 'hiddenInput',
                name: 'where',
                val: 'direct'
            },
            {
                block: 'b-banners-search-form',
                elem: 'search-fields',
                value: this.ctx.data.what || 'num',
                where: this.ctx.data.where,
                isBsShown: this.ctx.data.isBsShown
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: { elem: 'search-label' }
                    },
                    {
                        block: 'input',
                        mix: {
                            block: 'b-banners-search-form',
                            elem: 'number-input'
                        },
                        name: 'text_search',
                        value: this.ctx.data.textSearch || '',
                        content: { elem: 'control' }
                    }
                ]
            },
            {
                elem: 'row',
                mix: [{
                    block: 'b-banners-search-form',
                    elem: 'active-only-row'
                }],
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-banners-search-form',
                            elem: 'active-only'
                        }],
                        mods: { disabled: this.ctx.data.what == 'phrase' ? 'yes' : '' },
                        checkboxAttrs: { name: 'activeonly' },
                        text: iget2('b-banners-search-form', 'active-search-for-banners', 'искать только по активным объявлениям')
                    }
                ]
            },
            {
                elem: 'row',
                mix: [{
                    block: 'b-banners-search-form',
                    elem: 'group-row'
                }],
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'checkbox',
                        mods: { checked: this.ctx.data.groupCamp ? 'yes' : '' },
                        checkboxAttrs: { name: 'group_camp' },
                        text: iget2('b-banners-search-form', 'gruppirovat-po-kampaniyam', 'группировать по кампаниям')
                    }
                ]
            },
            {
                block: 'b-banners-search-form',
                elem: 'strict-search',
                strictSearch: this.ctx.data.strictSearch
            },
            {
                block: 'b-banners-search-form',
                elem: 'domain-fields',
                searchOrNet: this.ctx.data.searchOrNet
            },
            {
                block: 'b-banners-search-form',
                elem: 'additional-fields',
                retargetings: this.ctx.data.retargetings,
                strategy: this.ctx.data.strategy
            },
            {
                block: 'b-banners-search-form',
                elem: 'phrase-fields',
                useBansearch: this.ctx.data.useBansearch
            },
            {
                elem: 'row',
                elemMods: { type: 'search-bar' },
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-banners-search-form',
                            elem: 'submit'
                        }],
                        type: 'submit',
                        content: iget2('b-banners-search-form', 'nayti', 'Найти')
                    }
                ]
            }
        ];
    }),

    elem('search-fields').content()(function() {
        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'iskat-po', 'Искать по') + ':'
                },
                {
                    block: 'radiobox',
                    mix: {
                        block: 'b-banners-search-form',
                        elem: 'what'
                    },
                    name: 'what',
                    value: this.ctx.value,
                    content: [
                        {
                            title: iget2('b-banners-search-form', 'nomeru-obyavleniya', 'номеру объявления'),
                            for: 'direct',
                            value: 'num'
                        },
                        {
                            for: 'direct',
                            value: 'phrase',
                            title: iget2('b-banners-search-form', 'fraze', 'фразе')
                        },
                        {
                            for: 'direct',
                            value: 'domain',
                            title: iget2('b-banners-search-form', 'domenu', 'домену')
                        },
                        {
                            for: 'direct',
                            value: 'group',
                            title: iget2('b-banners-search-form', 'nomeru-gruppy', 'номеру группы')
                        }
                    ].map(function(btn) {
                        return {
                            elem: 'radio',
                            mix: {
                                block: 'b-banners-search-form',
                                elem: 'radio',
                                elemMods: {
                                    for: btn['for']
                                }
                            },
                            controlAttrs: { value: btn.value },
                            content: btn.title
                        };
                    }, this)
                }
            ]
        };
    })

);
