block('b-banners-search-form')(

    tag()('form'),

    attrs()(function() {
        return {
            action: this.ctx.actionUrl,
            method: 'GET'
        };
    }),

    elem('hiddenInput')(
        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name,
                value: this.ctx.val
            };
        })),

    elem('rows').content()(function() {
        return [
            {
                elem: 'hiddenInput',
                name: 'cmd',
                val: 'searchBanners'
            },
            {
                elem: 'hiddenInput',
                name: 'reverse',
                val: this.ctx.data.reverse || 1
            },
            {
                elem: 'hiddenInput',
                name: 'sort',
                val: this.ctx.data.sort || 'price'
            },
            {
                block: 'b-banners-search-form',
                elem: 'banners-type',
                where: this.ctx.data.where
            },
            {
                block: 'b-banners-search-form',
                elem: 'search-fields',
                value: this.ctx.data.what || 'num',
                where: this.ctx.data.where,
                isBsShown: this.ctx.data.isBsShown,
                data: this.ctx.data
            },
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: { elem: 'search-label' }
                    },
                    {
                        block: 'input',
                        mix: {
                            block: 'b-banners-search-form',
                            elem: 'number-input'
                        },
                        name: 'text_search',
                        value: this.ctx.data.textSearch || '',
                        content: { elem: 'control' }
                    }
                ]
            },
            {
                elem: 'row',
                elemMods: { type: 'separator' }
            },
            {
                elem: 'row',
                mix: [{
                    block: 'b-banners-search-form',
                    elem: 'active-only-row'
                }],
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'checkbox',
                        mix: [{
                            block: 'b-banners-search-form',
                            elem: 'active-only'
                        }],
                        mods: { disabled: this.ctx.data.what == 'phrase' ? 'yes' : '' },
                        checkboxAttrs: { name: 'activeonly' },
                        text: iget2('b-banners-search-form', 'active-search-for-banners','искать только по активным объявлениям')
                    }
                ]
            },
            {
                elem: 'row',
                mix: [{
                    block: 'b-banners-search-form',
                    elem: 'group-row'
                }],
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'checkbox',
                        mods: { checked: this.ctx.data.groupCamp ? 'yes' : '' },
                        checkboxAttrs: { name: 'group_camp' },
                        text: iget2('b-banners-search-form', 'gruppirovat-po-kampaniyam', 'группировать по кампаниям')
                    }
                ]
            },
            {
                elem: 'row',
                mix: [{
                    block: 'b-banners-search-form',
                    elem: 'currency-archived-row'
                }],
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'checkbox',
                        mods: { checked: this.ctx.data.includeCurrencyArchivedCampaigns ? 'yes' : '' },
                        checkboxAttrs: { name: 'include_currency_archived_campaigns' },
                        text: iget2('b-banners-search-form', 'pokazyvat-starye-kampanii-v', 'показывать старые кампании в у.е.')
                    }
                ]
            },
            {
                block: 'b-banners-search-form',
                elem: 'strict-search',
                strictSearch: this.ctx.data.strictSearch
            },
            {
                block: 'b-banners-search-form',
                elem: 'domain-fields',
                searchOrNet: this.ctx.data.searchOrNet
            },
            {
                block: 'b-banners-search-form',
                elem: 'additional-fields',
                retargetings: this.ctx.data.retargetings,
                strategy: this.ctx.data.strategy
            },
            {
                block: 'b-banners-search-form',
                elem: 'phrase-fields',
                useBansearch: this.ctx.data.useBansearch
            },
            {
                elem: 'row',
                elemMods: { type: 'search-bar' },
                content: [
                    {
                        elem: 'label'
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-banners-search-form',
                            elem: 'submit'
                        }],
                        type: 'submit',
                        content: iget2('b-banners-search-form', 'nayti', 'Найти')
                    }
                ]
            }
        ];
    }),

    elem('search-fields').content()(function() {
        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'iskat-po', 'Искать по') + ':'
                },
                {
                    block: 'radiobox',
                    mix: {
                        block: 'b-banners-search-form',
                        elem: 'what'
                    },
                    name: 'what',
                    value: this.ctx.value,
                    content: [
                        {
                            title: iget2('b-banners-search-form', 'nomeru-obyavleniya-v-direkte', 'номеру объявления в Директе'),
                            for: 'direct',
                            value: 'num'
                        },
                        this.ctx.isBsShown && {
                            title: iget2('b-banners-search-form', 'nomeru-obyavleniya-v-bk', 'номеру объявления в БК'),
                            for: 'direct',
                            value: 'banner_id'
                        },
                        {
                            for: 'mcb',
                            value: 'num_media',
                            title: iget2('b-banners-search-form', 'nomeru-obyavleniya', 'номеру объявления')
                        },
                        {
                            for: 'direct',
                            value: 'phrase',
                            title: iget2('b-banners-search-form', 'fraze', 'фразе')
                        },
                        {
                            for: 'direct',
                            value: 'domain',
                            title: iget2('b-banners-search-form', 'domenu', 'домену')
                        },
                        {
                            for: 'mcb',
                            value: 'domain_media',
                            title: iget2('b-banners-search-form', 'domenu', 'домену')
                        },
                        {
                            for: 'direct',
                            value: 'turbolanding',
                            title: iget2('b-banners-search-form', 'turbolanding', 'турбо-странице')
                        },
                        {
                            for: 'direct',
                            value: 'image_id',
                            title: iget2('b-banners-search-form', 'nomeru-izobrazheniya', 'номеру изображения')
                        },
                        {
                            for: 'direct',
                            value: 'group',
                            title: iget2('b-banners-search-form', 'nomeru-gruppy', 'номеру группы')
                        },
                        {
                            for: 'direct',
                            value: 'creative_nmb',
                            title: iget2('b-banners-search-form', 'nomeru-kreativa', 'номеру креатива')
                        }
                    ].map(function(btn) {
                        return {
                            elem: 'radio',
                            mix: {
                                block: 'b-banners-search-form',
                                elem: 'radio',
                                elemMods: {
                                    for: btn['for'],
                                    hidden: btn['for'] == this.ctx.where ? '' : 'yes'
                                }
                            },
                            controlAttrs: { value: btn.value },
                            content: btn.title
                        };
                    }, this)
                },
                {
                    block: 'b-banners-search-form',
                    elem: 'turbolanding-search-subtype-choose',
                    subtype: this.ctx.data.subtype || 'id'
                }
            ]
        };
    }),

    elem('additional-fields').content()(function() {
        return [
            {
                elem: 'row',
                mix: {
                    block: 'b-banners-search-form',
                    elem: 'retargeting-row'
                },
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-banners-search-form', 'usloviya-podbora-auditorii', 'Условия подбора аудитории') + ':'
                    },
                    {
                        block: 'radiobox',
                        mix: [{
                            block: 'b-banners-search-form',
                            elem: 'retargeting-radio'
                        }],
                        name: 'retargetings',
                        value: this.ctx.retargetings || '',
                        content: [
                            {
                                title: iget2('b-banners-search-form', 'est', 'есть'),
                                value: '1'
                            },
                            {
                                title: iget2('b-banners-search-form', 'net', 'нет'),
                                value: '0'
                            },
                            {
                                title: iget2('b-banners-search-form', 'ne-nbsp-uchityvat', 'не&nbsp;учитывать'),
                                value: ''
                            }
                        ].map(function(btn) {
                            return {
                                elem: 'radio',
                                mix: [{
                                    block: 'b-banners-search-form',
                                    elem: 'radiobutton'
                                }],
                                content: btn.title,
                                controlAttrs: { value: btn.value }
                            };
                        })
                    }
                ]
            },
            {
                elem: 'strategy-choose',
                selectedStrategy: this.ctx.strategy || ''
            }
        ];
    }),

    elem('phrase-fields').content()(function() {
        return {
            elem: 'row',
            mix: {
                block: 'b-banners-search-form',
                elem: 'phrase-row'
            },
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'tip-ploshchadok', 'Тип площадок') + ':'
                },
                {
                    block: 'radiobox',
                    mix: [{
                        block: 'b-banners-search-form',
                        elem: 'phrase-search-radio'
                    }],
                    name: 'use_bansearch',
                    value: this.ctx.useBansearch || '0',
                    content: [
                        {
                            title: iget2('b-banners-search-form', 'na-poiske-107', 'На Поиске'),
                            value: '0'
                        },
                        {
                            title: iget2('b-banners-search-form', 'v-rsya', 'В РСЯ'),
                            value: '1'
                        }
                    ].map(function(btn) {
                        return {
                            elem: 'radio',
                            mix: [{
                                block: 'b-banners-search-form',
                                elem: 'radiobutton'
                            }],
                            content: btn.title,
                            controlAttrs: { value: btn.value }
                        };
                    })
                }
            ]
        };
    }),

    elem('domain-fields').content()(function() {
        return {
            elem: 'row',
            mix: [{
                block: 'b-banners-search-form',
                elem: 'domain-row'
            }],
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'pokazy-v-setyah', 'Показы в сетях') + ':'
                },
                {
                    block: 'radiobox',
                    mix: [{
                        block: 'b-banners-search-form',
                        elem: 'search-or-net-radio'
                    }],
                    name: 'search_or_net',
                    value: this.ctx.searchOrNet || '',
                    content: [
                        {
                            elem: 'radio',
                            mix: [{
                                block: 'b-banners-search-form',
                                elem: 'radiobutton'
                            }],
                            content: iget2('b-banners-search-form', 'tolko-nbsp-seti', 'только&nbsp;сети'),
                            controlAttrs: { value: 'net' }
                        },
                        {
                            elem: 'radio',
                            mix: [{
                                block: 'b-banners-search-form',
                                elem: 'radiobutton'
                            }],
                            content: iget2('b-banners-search-form', 'tolko-nbsp-poisk', 'только&nbsp;Поиск'),
                            controlAttrs: { value: 'search' }
                        },
                        {
                            elem: 'radio',
                            mix: [{
                                block: 'b-banners-search-form',
                                elem: 'radiobutton'
                            }],
                            content: iget2('b-banners-search-form', 'ne-nbsp-uchityvat', 'не&nbsp;учитывать'),
                            controlAttrs: { value: '' }
                        }
                    ]
                }
            ]
        };
    }),

    elem('strict-search').content()(function() {
        return {
            elem: 'row',
            mix: [{
                block: 'b-banners-search-form',
                elem: 'strict-search-row'
            }],
            content: [
                {
                    elem: 'label'
                },
                {
                    block: 'checkbox',
                    mods: {
                        checked: this.ctx.strictSearch ? 'yes' : ''
                    },
                    checkboxAttrs: { name: 'strict_search' },
                    text: iget2('b-banners-search-form', 'iskat-po-tochnomu-sootvetstviyu', 'искать по точному соответствию')
                }
            ]
        };
    }),

    elem('banners-type').content()(function() {

        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-banners-search-form', 'type-of-ad', 'Тип объявления') + ':'
                },
                {
                    block: 'radio-button',
                    mix: {
                        block: 'b-banners-search-form',
                        elem: 'where'
                    },
                    name: 'where',
                    value: this.ctx.where,
                    content: [
                        {
                            elem: 'radio',
                            controlAttrs: { value: 'direct' },
                            content: iget2('b-banners-search-form', 'direkt', 'Директ')
                        },
                        {
                            elem: 'radio',
                            controlAttrs: { value: 'mcb' },
                            content: iget2('b-banners-search-form', 'mkb', 'МКБ')
                        }
                    ]
                }
            ]
        }
    })
);
