block('b-banners-search-form')(

    def()(function() {
        return applyNext({
            'ctx.actionUrl': u.getUrl('searchBanners')
        });
    }),

    addJs()(function() {
        return {
            activeOnly: this.data.FORM.activeonly == 'on' ? 'yes' : ''
        };
    }),

    content()(function() {

        var form = this.data.FORM,
            where = (form.where && form.where.toString()) ||
            (form.what && form.what.toString().indexOf('media') != -1 ? 'mcb' : 'direct');

        return {
            block: 'b-banners-search-form',
            elem: 'rows',
            data: {
                reverse: form.reverse,
                sort: form.sort,
                where: where,
                what: (form.what && form.what.toString()),
                textSearch: form.text_search,
                groupCamp: form.group_camp,
                includeCurrencyArchivedCampaigns: form.include_currency_archived_campaigns,
                strictSearch: form.strict_search,
                searchOrNet: form.search_or_net,
                useBansearch: form.use_bansearch,
                retargetings: form.retargetings,
                strategy: form.strategy,
                subtype: form.subtype,
                isBsShown: hasLoginRights('placer_control', 'support_control', 'super_control', 'superreader_control')
            }
        };
    })
);
