BEM.DOM.decl('b-banners-search-form', {

    onSetMod: {
        js: function() {

            BEM.blocks['i-utils'].graspSelf.call(this, {
                //по чему ищем (по фразе, номеру баннера, и т.п.)
                searchSubjectRadiobox: 'radiobox on what',
                netRadiobox: 'radiobox on search-or-net-radio',
                bansearchRadiobox: 'radiobox on phrase-search-radio',
                retargetingRadiobox: 'radiobox on retargeting-radio',
                strategySelect: 'select on strategy-select',
                //где ищем - Директ/МКБ
                whereRadiobutton: '? radio-button on where',
                activeOnlyCheckbox: 'checkbox on active-only',
                turbolandingSubtypeRadio: '? radiobox on turbolanding-search-subtype-radiobox'
            });

            this.activeOnlyLastState = this.params.activeOnly;

            this.searchSubjectRadiobox
                .on('change', this._onWhatChange, this)
                .trigger('change');
            this.netRadiobox
                .on('change', this._onSearchOrNetChange, this);

            this.whereRadiobutton && this.whereRadiobutton
                .on('change', this._onWhereChange, this);

            this.turbolandingSubtypeRadio && this.turbolandingSubtypeRadio
                .on('change', this._onTurbolandingSubtypeChange, this)
                .trigger('change');

            this._toggleStrategySelect(true);
        }
    },

    /**
     * Прячет лишние пункты в радиобоксе (Искать по),
     * в зависимости от выбранной площадки (директ или мкб).
     * Выбирает чекбокс с таким же значением,
     * если он есть при переключении (номер или домен)
     * @private
     */
    _onWhereChange: function() {
        var where = this.whereRadiobutton.val(),
            selectedType = this.searchSubjectRadiobox.val();

        this.setMod(this.elem('radio'), 'hidden', 'yes');

        this.setMod(
            this.elem('radio', 'for', where),
            'hidden',
            '');

        if (where == 'mcb') {
            selectedType == 'num' || selectedType == 'domain' ?
                this.searchSubjectRadiobox.val(selectedType + '_media') :
                this.searchSubjectRadiobox.val('num_media');
        } else {
            selectedType == 'domain_media' ?
                this.searchSubjectRadiobox.val('domain') :
                this.searchSubjectRadiobox.val('num');
        }
    },

    /**
     * Обработчик события смены значения на радиобоксе показов в РСЯ
     * @private
     */
    _onSearchOrNetChange: function() {
        this._toggleStrategySelect();
    },

    /**
     * Дизейблит инпут выбора стратегии и выбирает в нем "Независимое управление",
     * если выбран поиск по РСЯ
     * @private
     */
    _toggleStrategySelect: function(init) {
        this.netRadiobox.val() == 'net' ?
            this.strategySelect.val('different_places').setMod('disabled', 'yes') :
            !init && this.strategySelect.hasMod('disabled', 'yes') &&
                this.strategySelect.val('').setMod('disabled', '');
    },

    /**
     * Показывает или скрывает галочку для поиска по строгому соответствию
     * @param {Boolean} val
     * @private
     */
    _toggleStrictSearch: function(val) {
        this.setMod(this.elem('strict-search'), 'display', val ? 'yes' : '');
    },

    /**
     * Устанавливает значение лейбла инпута text_search
     * @param {String} label
     * @private
     */
    _setSearchLabel: function(label) {
        this.elem('search-label').text(label + ':');
    },

    /**
     * Отдает одно из двух значений лейбла инпута text_search для случая
     * поиска по турбостранице в зависимости от выбранного значения в радиобоксе
     * @private
     */
    _getTurbolandingSubtypeSearchLabel: function() {
        switch (this.turbolandingSubtypeRadio.val()) {
            case 'id':
                return iget2('b-banners-search-form', 'turbolanding-subtype-id', 'Id турбо-страницы');
            case 'name_part':
                return iget2('b-banners-search-form', 'turbolanding-subtype-name-part', 'Имя турбо-страницы');
            case 'url':
                return iget2('b-banners-search-form', 'turbolanding-subtype-url', 'URL турбо-страницы');
        }
    },

    /**
     * Обработчик события выбора пункта критерия поиска турбостраницы в радиобоксе
     * @private
     */
    _onTurbolandingSubtypeChange: function() {
        var whatVal = this.searchSubjectRadiobox.val();

        if (whatVal !== 'turbolanding') {
            return;
        }

        this._setSearchLabel(this._getTurbolandingSubtypeSearchLabel());
    },

    /**
     * Меняет лейбл инпута, в зависимости от выбранного в радиобоксе "Искать по" значения.
     * Дизейблит чекбокс поиска по активным баннерам, если выбран поиск по фразе.
     * @private
     */
    _onWhatChange: function() {
        var searchLabel,
            val = this.searchSubjectRadiobox.val(),
            additionalField = this.elem('additional-fields'),
            phraseFields = this.elem('phrase-fields'),
            domainFields = this.elem('domain-fields'),
            turbolandingSubtype = this.elem('turbolanding-search-subtype-choose');

        this._toggleStrictSearch(val == 'domain' || val == 'domain_media');

        if (val == 'phrase') {
            this
                .setMod(additionalField, 'display', 'yes')
                .setMod(phraseFields, 'display', 'yes')
                .setMod(domainFields, 'display', '')
                .setMod(turbolandingSubtype, 'display', 'no');
            this.netRadiobox.val('');
        } else if (val == 'domain') {
            this
                .setMod(additionalField, 'display', 'yes')
                .setMod(phraseFields, 'display', '')
                .setMod(domainFields, 'display', 'yes')
                .setMod(turbolandingSubtype, 'display', 'no');
            this.bansearchRadiobox.val('0');
        } else if (val === 'turbolanding') {
            this
                .setMod(additionalField, 'display', '')
                .setMod(phraseFields, 'display', '')
                .setMod(domainFields, 'display', '')
                .setMod(turbolandingSubtype, 'display', 'yes');
        } else {
            this.setMod(additionalField, 'display', '')
                .setMod(phraseFields, 'display', '')
                .setMod(domainFields, 'display', '')
                .setMod(turbolandingSubtype, 'display', 'no');
            this.netRadiobox.val('');
            this.retargetingRadiobox.val('');
            this.strategySelect.val('');
            this.bansearchRadiobox.val('0');
        }

        switch (val) {
            case 'num':
            case 'num_media':
            case 'banner_id':
                searchLabel = iget2('b-banners-search-form', 'nomer-obyavleniya', 'Номер объявления');
                break;
            case 'phrase':
                searchLabel = iget2('b-banners-search-form', 'fraza', 'Фраза');
                break;
            case 'domain':
            case 'domain_media':
                searchLabel = iget2('b-banners-search-form', 'domen-108', 'Домен');
                break;
            case 'turbolanding':
                searchLabel = this._getTurbolandingSubtypeSearchLabel();
                break;
            case 'image_id':
                searchLabel = iget2('b-banners-search-form', 'nomer-izobrazheniya', 'Номер изображения');
                break;
            case 'group':
                searchLabel = iget2('b-banners-search-form', 'nomer-gruppy', 'Номер группы');
                break;
            case 'creative_nmb':
                searchLabel = iget2('b-banners-search-form', 'nomer-kreativa', 'Номер креатива');
                break;
        }

        this._setSearchLabel(searchLabel);

        this.updateActiveOnlyCheckbox(val);
    },

    /**
     * Обновляет состояние чекбокса в зависимости от типа поиска
     * @param {String} searchType - тип поиска (значение поля "Искать по:")
     */
    updateActiveOnlyCheckbox: function(searchType) {
        if (searchType == 'phrase') {
            this.activeOnlyLastState = this.activeOnlyCheckbox.getMod('checked');
            this.activeOnlyCheckbox
                .delMod('disabled')
                .setMod('checked', 'yes')
                .setMod('disabled', 'yes');

        } else if (this.activeOnlyLastState !== undefined) {
            this.activeOnlyCheckbox
                .delMod('disabled')
                .setMod('checked', this.activeOnlyLastState);

            this.activeOnlyLastState = undefined;
        }
    }

});
