block('b-banners-search').elem('form')(

    js()(function() {
        return {
            bannerModes: apply('banner-options-by-type', { mediaType: this.ctx.mediaType })
        }
    }),

    content()(function() {
        var mediaType = this.ctx.mediaType,
            searchBannerOptions = apply('banner-options-by-type', { mediaType: mediaType });

        return [
            {
                block: 'b-form',
                attrs: {
                    action: u.getUrl('showCamp', { cid: this.ctx.cid, ulogin: this.ctx.ulogin })
                },
                content: [
                    {
                        block: 'b-hidden',
                        attrs: { name: 'cid', value: this.ctx.cid }
                    },
                    {
                        block: 'b-hidden',
                        attrs: { name: 'ulogin', value: this.ctx.ulogin }
                    },
                    {
                        block: 'b-hidden',
                        attrs: { name: 'cmd', value: 'showCamp' }
                    },
                    {
                        block: 'b-hidden',
                        attrs: { name: 'tab', value: 'all' }
                    },
                    {
                        block: 'radio-button',
                        mods: { size: 's' },
                        mix: {
                            block: 'b-banners-search',
                            elem: 'search-by'
                        },
                        name: 'search_by',
                        content: [
                            searchBannerOptions.map(function(option) {
                                return {
                                    elem: 'radio',
                                    elemMods: {
                                        checked: option.checked ? 'yes' : '',
                                        value: option.value
                                    },
                                    controlAttrs: {
                                        value: option.value
                                    },
                                    content: option.text
                                }
                            })
                        ]
                    },
                    {
                        block: 'b-banners-search',
                        elem: 'input-wrap',
                        content: [
                            {
                                elem: 'banner-label',
                                tag: 'span',
                                content: 'M-'
                            },
                            {
                                block: 'input',
                                mods: { size: 's' },
                                mix: {
                                    block: 'b-banners-search',
                                    elem: 'input-value'
                                },
                                placeholder: u._.find(searchBannerOptions, { checked: true }).label,
                                name: 'search_banner',
                                content: [
                                    { elem: 'control', attrs: { autocomplete: 'off' } },
                                    { elem: 'message', elemMods: { type: 'error' } }
                                ]
                            }
                        ]
                    }
                ]
            }
        ]
    }),

    mode('banner-options-by-type')(function() {

        var phrase = { value: 'phrase', text: iget2('b-banners-search', 'po-frazam', 'По фразам'), label: iget2('b-banners-search', 'fraza', 'Фраза'), type: 'string' },
            condition = { value: 'phrase', text: iget2('b-banners-search', 'po-usloviyam', 'По условиям'), label: iget2('b-banners-search', 'uslovie', 'Условие'), type: 'string' },
            group = { value: 'group', text: iget2('b-banners-search', 'po-gruppe', 'По группе'), label: iget2('b-banners-search', 'gruppa', 'Группа'), type: 'string' },
            context = { value: 'context', text: iget2('b-banners-search', 'po-tekstu', 'По тексту'), label: iget2('b-banners-search', 'tekst', 'Текст'), type: 'string' },
            numAd = {
                value: 'num',
                text: iget2('b-banners-search', 'po-nomeru-obyavleniya', 'По номеру объявления'),
                label: iget2('b-banners-search', 'nomer-obyavleniya', 'Номер объявления'),
                type: 'number',
                errorText: iget2('b-banners-search', 'vy-dolzhny-vvesti-nomer', 'Вы должны ввести номер объявления как число'),
                checked: true
            };

        switch (this.mediaType) {
            case 'performance':
                return [
                    {
                        value: 'num',
                        text: iget2('b-banners-search', 'po-nomeru-bannera', 'По номеру баннера'),
                        label: iget2('b-banners-search', 'nomer-bannera', 'Номер баннера'),
                        type: 'number',
                        errorText: iget2('b-banners-search', 'vy-dolzhny-vvesti-nomer-105', 'Вы должны ввести номер баннера как число'),
                        checked: true
                    },
                    { value: 'filter', text: iget2('b-banners-search', 'po-filtram', 'По фильтрам'), label: iget2('b-banners-search', 'filtr', 'Фильтр'), type: 'string' },
                    group
                ];

            case 'dynamic':
                return [
                    numAd,
                    context,
                    condition,
                    group
                ];

            case 'mcbanner':
                return [
                    {
                        value: 'num',
                        text: iget2('b-banners-search', 'po-nomeru-bannera', 'По номеру баннера'),
                        label: iget2('b-banners-search', 'nomer-bannera', 'Номер баннера'),
                        type: 'number',
                        errorText: iget2('b-banners-search', 'vy-dolzhny-vvesti-nomer-105', 'Вы должны ввести номер баннера как число'),
                        checked: true
                    },
                    phrase,
                    group
                ];

            case 'cpm_banner':
            case 'cpm_deals':
                return [
                    numAd,
                    phrase,
                    group
                ];

            default:
                return [
                    numAd,
                    context,
                    phrase,
                    group
                ];
        }
    })
);
