block('b-banners-search')(

    js()(true),

    content()(function() {

        var ctx = this.ctx,
            mediaType = ctx.mediaType,
            cid = ctx.cid,
            ulogin = ctx.ulogin,
            isCampaignArchived = ctx.isCampaignArchived,
            showGroupTab = !(isCampaignArchived || mediaType == 'dynamic' || mediaType == 'performance');

        return [
            {
                elem: 'title',
                content: iget2('b-banners-search', 'poisk-po-kampanii', 'Поиск по кампании')
            },
            {
                elem: 'content',
                content: [
                    {
                        block: 'tabs',
                        mods: {
                            control: 'menu',
                            size: 's',
                            theme: 'normal-red',
                            layout: 'horiz'
                        },
                        mix: { block: 'b-banners-search', elem: 'tabs' },
                        panes: 'b-banners-search-tabs',
                        content: [
                            {
                                elem: 'tab',
                                elemMods: { active: 'yes' },
                                content: {
                                    block: 'link',
                                    content: mediaType == 'performance' || mediaType == 'mcbanner' ?
                                        iget2('b-banners-search', 'bannery', 'Баннеры') :
                                        iget2('b-banners-search', 'obyavleniya', 'Объявления')
                                }
                            },
                            showGroupTab && {
                                elem: 'tab',
                                content: {
                                    block: 'link',
                                    content: iget2('b-banners-search', 'gruppy', 'Группы')
                                }
                            }
                        ]
                    },
                    {
                        block: 'tabs-panes',
                        mix: { block: 'b-banners-search', elem: 'tabs-panes' },
                        id: 'b-banners-search-tabs',
                        content: [
                            {
                                elem: 'pane',
                                elemMods: { active: 'yes' },
                                content: [
                                    {
                                        block: 'b-banners-search',
                                        elem: 'form',
                                        cid: cid,
                                        ulogin: ulogin,
                                        mediaType: mediaType
                                    }
                                ]
                            },
                            showGroupTab && {
                                elem: 'pane',
                                content: {
                                    block: 'b-banners-search',
                                    elem: 'form',
                                    elemMods: { type: 'group' },
                                    cid: cid,
                                    ulogin: ulogin,
                                    mediaType: mediaType
                                }
                            }
                        ]
                    },
                    {
                        elem: 'message',
                        elemMods: { result: 'no' },
                        content: [
                            {
                                block: 'icon',
                                mix: {
                                    block: 'b-banners-search',
                                    elem: 'message-icon'
                                },
                                mods: { 'size-12': 'info' }
                            },
                            {
                                elem: 'message-text',
                                content: iget2('b-banners-search', 'nichego-ne-naydeno', 'Ничего не найдено')
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'footer',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: [{ block: 'b-banners-search', elem: 'submit' }],
                        content: iget2('b-banners-search', 'nayti', 'Найти')
                    },
                    {
                        block: 'button',
                        mix: [{ block: 'b-banners-search', elem: 'cancel' }],
                        type: 'button',
                        content: iget2('b-banners-search', 'otmena', 'Отмена')
                    }
                ]
            }
        ];
    })
);
