/**
 * Модуль обработки поп-апа поиска объявлений в кампании
 */
BEM.DOM.decl('b-banners-search', {

    onSetMod: {
        /**
         * инициализация полей и событий
         */
        js: function() {

            u.graspSelf.call(this, {
                _submit: 'button on submit',
                _cancel: 'button on cancel',
                _tabs: 'tabs on tabs',
                _tabsPanes: 'tabs-panes on tabs-panes'
            });

            this._subMan = BEM.create('i-subscription-manager')
                .on(this._submit, 'click', this._getBannersCount, this)
                .on(this._cancel, 'click', this._hide, this)
                .on(this._tabs, 'change', this._hideNotFoundMessage, this);
        }
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        this._subMan.dispose();
        return this.__base.apply(this, arguments);
    },

    /**
     * проверка, что содержимое _input соответствует выбранному в _searchModes
     * @returns {boolean}
     */
    validate: function() {
        var error,
            input = this._input,
            val = input.val(),
            mode = this._searchModes[this._current];

        if (mode.type == 'number' && !val.match(/\d+/)) {
            error = mode.errorText || iget2('b-banners-search', 'vy-dolzhny-vvesti-chislo', 'Вы должны ввести число');
        } else if (mode.type == 'string' && !val.match(/.+/)) {
            error = iget2('b-banners-search', 'vy-dolzhny-vvesti-tekst', 'Вы должны ввести текст');
        }

        if (error) {
            var messageDom = input.elem('message', 'type', 'error');

            input.setMod(messageDom, 'visibility', 'visible');
            BEM.DOM.update(messageDom, error);
        }

        return !error;
    },

    /**
     * Прячет поп-ап
     * @private
     */
    _hide: function() {
        this.findBlockOutside('popup').hide();
    },

    /**
     * Обработка нажатия на энтер в поле поиска
     * @param {jQuery} e событие
     * @private
     */
    _applySearchModes: function(e) {
        var nextKey = e.block.val(),
            nextMode = this._searchModes[nextKey];

        this._searchModes[this._current].prev = this._input.val();
        this._input
            .delMod(this._input.elem('message', 'type', 'error'), 'visibility')
            .val(nextMode.prev || '');

        BEM.DOM.update(this.elem('label'), nextMode.label);

        this._current = nextKey;
    },

    /**
     * Показывает сообщение о неудачном поиске
     * @private
     */
    _showNotFoundMessage: function() {
        this.setMod('result', 'no');
    },

    /**
     * Скрывает сообщение о неудачном поиске
     * @private
     */
    _hideNotFoundMessage: function() {
        this.delMod('result');
    },

    /**
     * Создает ajax-запрос на количество баннеров,
     * удовлетворяющих условию поиска
     * Если результат ненулевой, отправляет форму с данными
     * Иначе показывает сообщение
     * @private
     */
    _getBannersCount: function() {
        var form = this.findBlockInside(this._tabsPanes.findPane('active', 'yes'), 'b-banners-search__form'),
            formObject = form.findBlockInside('b-form').getData();

        if (!form.validate()) return;

        this._request || (this._request = BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            cache: false,
            callbackCtx: this
        }));

        BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
            params: {
                showCamp: {
                    'banners-search': {
                        action: 'search',
                        data: {
                            search_banner: formObject.search_banner,
                            search_by: formObject.search_by,
                            search_rarely_loaded: formObject.search_rarely_loaded,
                            search_status: formObject.search_status,
                            disabled_geo_only: formObject.disabled_geo_only
                        }
                    }
                }
            }
        });

        this._request.get(
            u._.extend(formObject,{ cmd: 'ajaxGetBannersCount' }),
            function(data) {
                if (data) {
                    form.submit();
                } else {
                    this._showNotFoundMessage();
                }
            });
    }
});
