block('b-banners-to-media')(

    addJs()(true),

    content()(function() {
        return {
            block: 'b-layout-form',
            mix: [{
                block: 'i-form'
            }],
            header: iget2('b-banners-to-media', 'skopirovat-obyavleniya-v-kotoryh', 'Скопировать объявления, в которых'),

            rows: [
                {
                    name: 'has_ctr',
                    options: iget2('b-banners-to-media', 'est-klyuchevye-frazy-s', 'Есть ключевые фразы с CTR {percent}', {
                        percent: [
                            '&nbsp;<&nbsp;',
                            {
                                elem: 'select',
                                name: 'ctr_value',
                                values: ['1', '3', '5']
                            },
                            '&nbsp;%'
                        ]
                    })
                },
                {
                    name: 'has_phrases_count',
                    options: [
                        iget2('b-banners-to-media', 'bolshe-nbsp-phrase-nbsp', 'больше &nbsp;{phrase}&nbsp; ключевых фраз', {
                            phrase: {
                                elem: 'select',
                                name: 'phrases_count_value',
                                values: ['3', '5', '10', '15', '25']
                            }
                        }),
                        {
                            elem: 'row-label',
                            elemMods: { color: 'gray' },
                            content: ['(', iget2('b-banners-to-media', 'bez-ucheta-shablonov', 'без учета шаблонов'), ')']
                        }
                    ]
                },
                {
                    name: 'has_one_word_phrase',
                    options: iget2('b-banners-to-media', 'est-klyuchevye-frazy-sostoyashchie', 'Есть ключевые фразы состоящие из одного слова')
                },
                {
                    name: 'has_absent_phrases',
                    options: [
                        iget2(
                            'b-banners-to-media',
                            'est-takie-frazy-ni',
                            'Есть такие фразы, ни одно слово которых не использовано в тексте или заголовке объявления'
                        ),
                        {
                            elem: 'row-label',
                            elemMods: { color: 'gray' },
                            content: [
                                '(',
                                iget2('b-banners-to-media', 'bez-ucheta-shablonov', 'без учета шаблонов'),
                                ')'
                            ]
                        }
                    ]
                },
                {
                    name: 'has_forecast',
                    options: iget2(
                        'b-banners-to-media',
                        'est-klyuchevye-frazy-prognoziruemoe',
                        'Есть ключевые фразы, прогнозируемое кол-во показов которых более {count} в месяц',
                        {
                            count: {
                                elem: 'select',
                                name: 'forecast_value',
                                values: ['500', '1000', '5000', '10000', '30000']
                            }
                        }
                    )
                }
            ].map(function(r, n, rows) {
                return {
                    control: {
                        block: 'b-banners-to-media',
                        elem: 'row',
                        elemMods: n != rows.length - 1 ? { hasOrLabel: 'yes' } : {},
                        content: [
                            {
                                block: 'checkbox',
                                checkboxAttrs: { name: r.name },
                                text: r.label || ''
                            },
                            r.options && {
                                elem: 'row-options',
                                content: r.options
                            }
                        ]
                    }
                };
            }),

            hiddenInputs: [
                {
                    name: 'cid',
                    value: this.data.cid
                },
                {
                    name: 'ulogin',
                    value: this.data.user_login
                }
            ],

            submit: {
                block: 'b-banners-to-media',
                elem: 'buttons',
                content: [
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-banners-to-media',
                            elem: 'submit-button'
                        }],
                        content: iget2('b-banners-to-media', 'skopirovat-v-mediaplan', 'Скопировать в медиаплан')
                    },
                    {
                        block: 'button',
                        mix: [{
                            block: 'b-banners-to-media',
                            elem: 'cancel-button'
                        }],
                        content: iget2('b-banners-to-media', 'otmenit', 'Отменить')
                    }
                ]
            }
        };
    })
);
