(function() {
    var confirm = BEM.blocks['b-confirm'];

    /**
     * @event b-banners-to-media#ready-to-copy
     * @type {Object}
     * @property {String[]} bids Идентификаторы баннеров
     *
     * @fires b-banners-to-media#ready-to-copy событие готовности баннеров к копированию в медиаплан
     */
    BEM.DOM.decl('b-banners-to-media', {

        onSetMod: {

            js: function() {
                this._popup = this.findBlockOutside('popup');
                this._popup.on('hide', function() {
                    this.setDefaultValues();
                }, this);

                this.findBlockOn('cancel-button', 'button').on('click', this.hide, this);
                this.findBlockOn('submit-button', 'button').on('click', this._onSubmit, this);

                this.setDefaultValues();
            }

        },

        hide: function() {
            this._popup = this.findBlockOutside('popup'); //todo: разобраться, где обнуляется popup
            this._popup.hide();

            return this;
        },

        setDefaultValues: function() {

            var selectValues = {
                'ctr-value': '1',
                'phrases-count-value': '25',
                'forecast-value': '500'
            };

            this.findBlocksInside('checkbox').forEach(function(v) {
                v.delMod('checked');
            });

            for (var name in selectValues) {
                this.findBlockOn(name, 'select').val(selectValues[name]);
            }

            return this;
        },

        _onSubmit: function(e) {
            var fields = [
                    'has_ctr', 'has_phrases_count',
                    'has_one_word_phrase', 'has_one_word_phrase', 'has_absent_phrases',
                    'has_forecast'
                ],
                data = this.findBlockInside('i-form').serialize();

            data.cmd = 'ajaxGetFilteredBanners';

            fields.forEach(function(v) {
                data[v] = +!!data[v];
            });

            this._request || (this._request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                dataType: 'json',
                cache: false,
                callbackCtx: this
            }));

            this._request.get(data, function(response) {
                if (!response.count) {
                    confirm.alert(iget2('b-banners-to-media', 'ne-naydeno-ni-odnogo', 'Не найдено ни одного объявления'), this._popup);
                } else {
                    confirm.open({
                        message: iget2('b-banners-to-media', 's-obyavleniy-budet-skopirovano', '{foo} объявлений будет скопировано в медиаплан', {
                            foo: response.count
                        }),
                        onYes: function() {
                            this.trigger('ready-to-copy', {
                                bids: response.bids
                            });
                        },
                        onNo: this.hide,
                        fromPopup: this._popup
                    }, this);
                }
            });
        }
    });
})();
