BEM.DOM.decl({ block: 'b-brand-safety-dna' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna,
                ulogin = this.params.ulogin,
                cid = this.params.cid || 0,
                isEditMode = this.params.isEditMode,
                allBrandSafetyCategories = this.params.allBrandSafetyCategories;

            this._selectedCategoriesIds = this.params.brandSafetyCategories.map(function(catId) {
                return catId.toString();
            });

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this._renderDna(dna, ulogin, cid, allBrandSafetyCategories, this._selectedCategoriesIds, isEditMode);
        }
    },

    _renderDna: function(dna, login, campaignId, allCategories, selectedCategoriesIds, isEditMode) {
        var dnaComp = dna.reactCreateElement(
            dna.components.BrandSafetyWrapper,
            {
                login: login,
                campaignId: campaignId,
                isEditMode: isEditMode,
                allBrandSafetyCategories: allCategories,
                selectedCategoriesIds: selectedCategoriesIds
            },
            null,
            {
                disableBaobab: true
            }
        );

        return new Promise(function(resolve) {
            dna.reactDOMRender(
                dnaComp,
                this.domElem.get(0),
                function() {
                    resolve(this);
                }
            );
        }.bind(this)).then(function(res) {
            this._dnaComp = res;
        }.bind(this));
    },

    getValue: function() {
        if (this._dnaComp) {
            return this._dnaComp.getSelectedCategories();
        } else {
            return this._selectedCategoriesIds;
        }
    }
});
