block('b-brand-safety-popup')(

    js()(function() {
        return {
            brandSafetyCategories: this.ctx.brandSafetyCategories,
            allBrandSafetyCategories: this.ctx.allBrandSafetyCategories,
            cid: this.ctx.cid,
            ulogin: this.ctx.ulogin
        };
    }),

    content()(function() {

        var brandSafetyCategories = this.ctx.brandSafetyCategories,
            allBrandSafetyCategories = this.ctx.allBrandSafetyCategories,
            cid = this.ctx.cid,
            ulogin = this.ctx.ulogin,
            helpId = u.consts('isFeatureBrandSafetyAdditionalCategoriesEnabled') ?
                'brand-safety-extra' : 'brand-safety';

        return [
            {
                block: 'b-modal-popup-decorator',
                elem: 'header',
                content: [
                    {
                        block: 'b-modal-popup-decorator',
                        elem: 'title',
                        content: [
                            iget2('b-brand-safety-popup', 'title', 'Brand safety'),
                            {
                                block: 'b-help-link',
                                mods: { type: 'modal' },
                                mix: {
                                    block: 'b-brand-safety-popup',
                                    elem: 'help-link'
                                },
                                stretched: true,
                                url: u.getHelpUrl(helpId)
                            }
                        ]
                    }
                ]
            },
            {
                elem: 'body',
                content: {
                    block: 'b-brand-safety-dna',
                    mix: {
                        block: 'b-brand-safety-popup',
                        elem: 'edit-brand-safety'
                    },
                    brandSafetyCategories: brandSafetyCategories,
                    allBrandSafetyCategories: allBrandSafetyCategories,
                    cid: cid,
                    ulogin: ulogin,
                    isEditMode: true
                }
            },
            {
                block: 'b-modal-popup-decorator',
                elem: 'footer',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action', size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-brand-safety-popup', elem: 'save' }
                        ],
                        content: iget2('b-brand-safety-popup', 'save', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mods: { size: 's' },
                        mix: [
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' },
                            { block: 'b-brand-safety-popup', elem: 'cancel' }
                        ],
                        content: iget2('b-brand-safety-popup', 'cancel', 'Отмена')
                    }
                ]
            }
        ];
    })
);
