BEM.DOM.decl({ block: 'b-brand-safety-popup', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            BEM.blocks['i-utils'].graspSelf.call(this, {
                _saveBtn: 'button on save',
                _cancelBtn: 'button on cancel',
                _editControl: 'b-brand-safety-dna on edit-brand-safety'
            });

            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.on(this._saveBtn, 'click', this._onSaveBtnClick, this);
            this._subscribe.on(this._cancelBtn, 'click', this._onCancelBtnClick, this);
        }
    },

    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(true);

        return deferred;
    },

    destruct: function() {
        this._subscribe.dispose();

        return this.__base.apply(this, arguments);
    },

    _onSaveBtnClick: function() {
        this.trigger('save', { value: this._editControl.getValue() });
    },

    _onCancelBtnClick: function() {
        this.trigger('cancel');
    }
});
