block('b-brand-safety')(
    js()(function() {
        return {
            brandSafetyCategories: this.ctx.brandSafetyCategories,
            cid: this.ctx.cid,
            ulogin: this.ctx.ulogin
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            brandSafetyCategories = ctx.brandSafetyCategories,
            hiddenInputJson;

        if (this.ctx.hiddenControlName) {
            hiddenInputJson = {
                block: 'b-brand-safety',
                elem: 'hidden-input',
                hiddenControlName: this.ctx.hiddenControlName,
                value: brandSafetyCategories
            };
        }

        return [
            hiddenInputJson,
            {
                block: 'spin',
                js: true,
                mods: { progress: 'yes', theme: 'gray-16' },
                mix: [{ block: 'b-brand-safety', elem: 'spin' }]
            },
            {
                elem: 'b-brand-safety-dna-preview'
            },
            {
                block: 'button',
                mods: {
                    theme: 'normal',
                    size: 's'
                },
                mix: {
                    block: 'b-brand-safety',
                    elem: 'opener',
                    elemMods: { hidden: 'yes' }
                },
                content: iget2('b-brand-safety', 'change-btn', 'Изменить')
            }
        ]
    })
);
