BEM.DOM.decl({ block: 'b-brand-safety' }, {
    onSetMod: {
        js: function() {
            this.setMod('loading', 'yes');

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this._opener = this.findBlockOn('opener', 'button');

            if (this._opener) {
                this._subscriptionManager.on(this._opener, 'click', function() {
                    this._openEditPopup();
                }, this);
            }

            var dna = window.dna,
                ulogin = this.params.ulogin,
                queryExecutor = dna.utils.getQueryExecutor(ulogin),
                captureException = dna.utils.captureException;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            queryExecutor.getBrandSafetyCategories(ulogin)
                .then(function(allCategories) {
                    this._allCategoriesWithStrId = allCategories.map(function(cat) {
                        return {
                            id: cat.id.toString(),
                            name: cat.name,
                            description: cat.description
                        }
                    });

                    BEM.DOM.replace(
                        this.findElem('b-brand-safety-dna-preview'),
                        BEMHTML.apply(
                            this._getPreviewBlock(this.params.brandSafetyCategories, this.params)
                        )
                    );

                    this.delMod('loading');
                }.bind(this)).catch(function(err) {
                    captureException('yesReallyThisIsAnError', err, {
                        source: 'brandSafetyCategories',
                        block: 'b-brand-safety',
                        message: 'Query error: getBrandSafetyCategories',
                        extra: {
                            login: ulogin
                        }
                    });
                });
        },

        loading: function(modName, modVal) {
            this
                .setMod(this.elem('spin'), 'hidden', modVal !== 'yes' ? 'yes' : '')
                .setMod(this.elem('opener'), 'hidden', modVal);
        }
    },

    _getPreviewBlock: function(brandSafetyCategories, params) {
        return {
            block: 'b-brand-safety-dna',
            mix: {
                block: 'b-brand-safety',
                elem: 'b-brand-safety-dna-preview'
            },
            brandSafetyCategories: brandSafetyCategories,
            allBrandSafetyCategories: this._allCategoriesWithStrId,
            cid: params.cid,
            ulogin: params.ulogin,
            isEditMode: false
        };
    },

    destruct: function() {
        this._subscriptionManager.dispose();
        this._subscriptionManager.destruct();

        return this.__base.apply(this, arguments);
    },

    _openEditPopup: function() {
        var modalPopupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(null, { bodyScroll: false }, $),
            popup = modalPopupDecorator.getPopup(),
            instance,
            params = this.params;

        instance = modalPopupDecorator
            .on('close-blocked', function() {
                BEM.blocks['b-user-dialog'].confirm({
                    message: iget2('b-brand-safety', 'changes-will-not-save', 'Изменения не будут сохранены. Продолжить?'),
                    onConfirm: function() {
                        modalPopupDecorator.hide({ force: true });
                    }
                });
            }, this)
            .setPopupContent({
                block: 'b-brand-safety-popup',
                brandSafetyCategories: this._savedValue || params.brandSafetyCategories,
                allBrandSafetyCategories: this._allCategoriesWithStrId,
                cid: params.cid,
                ulogin: params.ulogin
            })
            .on('save', function(event, data) {
                this._savedValue = data.value;

                BEM.DOM.replace(
                    this.findElem('b-brand-safety-dna-preview'),
                    BEMHTML.apply(
                        this._getPreviewBlock(this._savedValue, params)
                    )
                );

                var savedValueAsInt = this._savedValue.map(function(catId) {
                    return parseInt(catId);
                });

                if (this.elem('hidden-input').length) {
                    this.elem('hidden-input').val(JSON.stringify(savedValueAsInt));
                }

                modalPopupDecorator.hide({ force: true });
            }, this)
            .on('cancel', function() {
                modalPopupDecorator.hide({ force: true });
            });

        popup.on('hide', function() {
            modalPopupDecorator.destruct();
        });

        instance._popup = modalPopupDecorator;
        modalPopupDecorator.show();

        return instance;
    }
});
