BEM.decl('b-callouts-manager', {

    onSetMod: {
        js: function() {
            this._initEvents();
        }
    },

    /**
     * Подписывает блок на события
     * @private
     */
    _initEvents: function() {
        this._subscribeManager = BEM.create('i-subscription-manager');

        this._subscribeManager.on(this.channel('callouts'), 'destroy', this._onDestoyRequest, this);
    },

    /**
     * Обработчик события destroy
     * Удаляет уточнение по id из моделей баннеров
     * @param {jQuery.Event} e
     * @param {Object} data
     * @param {Object} data.id Идентификатор уточнения
     * @private
     */
    _onDestoyRequest: function(e, data) {
        this._getGroupModels().forEach(function(groupModel) {
            groupModel.getBannersWithCalloutId(data.id).forEach(function(banner) {
                banner.deleteCalloutById(data.id);
            });
        })
    },

    /**
     * Возвращает массив моделей групп с id, указанными в groupsIds
     * @returns {Array}
     * @private
     */
    _getGroupModels: function() {
        return this.params.groupsIds.map(function(id) {
            return BEM.MODEL.getOrCreate({
                name: this.params.groupModelName,
                id: id
            });
        }, this);
    },

    destruct: function() {
        this._subscribeManager.dispose();
        this.__base.apply(this, arguments);
    }
});
