block('b-callouts-selector-item')(

    js()(true),

    mix()(function() {
        return {
            mods: { id: this.ctx.id }
        };
    }),

    content()(function() {
        var stateModVal = {
            Sent: 'moderation',
            Sending: 'moderation',
            Ready: 'moderation',
            No: 'rejected'
        }[this.ctx.state];

        return [
            {
                elem: 'text',
                elemMods: { state: stateModVal },
                mix: this.ctx.mixToText,
                content: this.ctx.text
            },
            {
                elem: 'status-moderate',
                elemMods: { state: stateModVal }
            },
            {
                elem: 'pending-status',
                elemMods: { hidden: 'yes' }
            },
            {
                block: 'button',
                mods: { size: 'xs', theme: 'icon', 'only-icon': 'yes' },
                mix: [{
                    block: 'b-callouts-selector-item',
                    elem: 'delete-selected-item'
                }],
                content: {
                    block: 'icon',
                    mods: { 'size-16': 'delete', theme: 'light' },
                    mix: { block: 'button', elem: 'icon' }
                }
            }
        ];
    }),

    elem('status-moderate')(

        elemMod('state', 'moderation').content()(function() {
            return iget2('b-callouts-selector-item', 'na-moderacii-110', 'на модерации');
        }),

        elemMod('state', 'rejected').content()(function() {
            return iget2('b-callouts-selector-item', 'otklonen', 'отклонен');
        })

    )
);
