/**
 * @fires b-callouts-selector-item#delete
 * @fires b-callouts-selector-item#basket-mouse
 */
BEM.DOM.decl('b-callouts-selector-item', {

    onSetMod: {
        js: function() {
            this._deleteButton = this.findBlockOn('delete-selected-item', 'button');
        },

        deleting: function(modName, modVal) {
            this._togglePendingStatus(!!modVal, iget2('b-callouts-selector-item', 'udalyaetsya', 'удаляется...'));
            this._deleteButton.setMod('disabled', modVal ? 'yes' : '');
        }
    },

    /**
     * Показывает / скрывает текстовку выполнения действия
     * @param {Boolean} flag
     * @param {String} statusText
     * @private
     */
    _togglePendingStatus: function(flag, statusText) {
        this.elem('pending-status').text(flag ? statusText : '');
        this.setMod(this.elem('pending-status'), 'hidden', flag ? '' : 'yes');
        this.setMod(this.elem('status-moderate'), 'hidden', flag ? 'yes' : '');
    },

    /**
     * Триггерит событие delete
     * @param {jQuery.Event} e
     * @param {Object} data
     * @private
     */
    _deleteSelectedItem: function(e, data) {
        this.trigger('delete', {
            id: this.getMod('id')
        });
    },

    /**
     * Обработчик наведения и ухода мыши с корзины
     * @param {jQuery.Event} e
     * @private
     */
    _onMouseOverOut: function(e) {
        this.trigger('basket-mouse', {
            mode: e.type === 'pointerover' ? 'over' : 'out',
            domElem: e.data.domElem
        });
    }

}, {

    live: function() {
        this
            .liveBindTo('delete-selected-item', 'click', function(e, data) {
                // останавливаем всплытие события `click` к блоку `b-chooser`
                // грабли:
                // DIRECT-53935: ТС: стратегии, не меняются/не сохраняются значения
                // DIRECT-71829: Не удаляются уточнения при нажатии на значок корзины
                e.stopPropagation();

                this._deleteSelectedItem(e, data);
            })
            .liveBindTo('delete-selected-item', 'pointerover pointerout', function(e, data) {
                this._onMouseOverOut(e, data);
            });
    }

});
