BEM.DOM.decl({ block: 'b-callouts-selector', modName: 'mode', modVal: 'multi' }, {

    onSetMod: {

        selection: {

            'some-different': function() {
                var diffCount = this._model.get('diffCount');

                this._setSelectionMessage(
                    u.pluralForms(iget2('b-callouts-selector', 'eshchyo-s-utochnenie-utochneniya', 'Ещё {foo} {уточнение|уточнения|уточнений} не совпадает', {
                        foo: diffCount
                    }), diffCount));
            },

            'fully-different': function() {
                this._setSelectionMessage(iget2('b-callouts-selector', 'v-vybrannyh-obyavleniyah-raznye', 'В выбранных объявлениях разные уточнения'));
            }

        }

    },

    /**
     * Возвращает имя view-модели
     * @returns {string}
     * @private
     */
    _getModelName: function() {
        return 'b-callouts-selector_mode_multi';
    },

    /**
     * Подписывает блок на события
     * @private
     */
    _initEvents: function() {
        this.__base.apply(this, arguments);

        this._subMan.wrap(this._model)
            .on('calloutsKits', 'change', this._onDependsValueFieldsChange, this)
            .on('diffCount', 'change', this._updateSelectionStatus, this);
    },

    /**
     * Обновляет модификатор выбранности уточнений `_selection`
     * @private
     */
    _updateSelectionStatus: function() {
        var haveSelected = this._model.get('haveSelected'),
            diffCount = this._model.get('diffCount');

        if (diffCount) {
            if (haveSelected) {
                this
                    // Для того чтобы отработал обработчик установки модификатора `_selection_some-different`,
                    // т.к. там задается количество несовпадающих уточнений из поля модели
                    .delMod('selection')
                    .setMod('selection', 'some-different');
            } else {
                this.setMod('selection', 'fully-different');
            }
        } else {
            return this.__base.apply(this, arguments);
        }
    },

    /**
     * Заполняет модель данными и отключает прелоадер
     * @param {Object} blockData - входные данные блока
     * @param {Object[][]} blockData.calloutsKits Выбранные уточнения баннеров
     * @param {Object[]} [blockData.callouts] Выбранные уточнения к баннеру
     * @param {Object} serverData - серверные данные
     * @param {Object[]} serverData.callouts - серверные данные
     * @private
     */
    _initPopup: function(blockData, serverData) {
        this._model
            .set('calloutsKits', blockData.calloutsKits || [blockData.callouts])
            .set('list', this._getAvaliableItems(serverData.callouts, this._model.get('calloutsIntersectionIds')))
            .set('inited', true)
            .fix();

        this.delMod('pending');
    },

    /**
     * Сообщает о факте изменения входных и выходных данных
     * @returns {Boolean}
     * @private
     */
    _isChanged: function() {
        return this.__base.apply(this, arguments) || this._model.isChanged('calloutsKits');
    },

    /**
     * Возвращает выбранные пользователем значения
     * @returns {{calloutsKits: object[], callouts: object}}
     */
    val: function() {
        var model = this._model,
            selectedCallouts = (this.__base.apply(this, arguments) || {}).callouts,
            calloutsIntersectionIds = model.get('calloutsIntersectionIds'),
            calloutsKits = model.get('calloutsKits');

        return {
            calloutsKits: model.get('diffCount') ?
                calloutsKits.map(function(callouts) {
                    return this._mergeCallouts(callouts, calloutsIntersectionIds, selectedCallouts)
                }, this) :
                calloutsKits.map(function() {
                    return selectedCallouts;
                }),
            callouts: selectedCallouts
        }
    },

    /**
     * Строит из массива идентификаторов объект, по которому можно фильтровать другой массив
     * @param {String[]|Number[]} array
     * @returns {Object}
     * @private
     */
    _getObjectMapForFilter: function(array) {
        return array.reduce(function(result, item) {
            result[item] = true;

            return result;
        }, {});
    },

    /**
     * Возвращает поле `additions_item_id` у передаваемого объекта
     * @param {Object} obj
     * @param {String} obj.additions_item_id
     * @returns {String}
     * @private
     */
    _getAdditionsItemId: function(obj) {
        return obj.additions_item_id;
    },

    /**
     * Применяет результат выбора уточнений к существующему набору уточнений баннера
     * @param {Object} prevValue набор уточнений баннера
     * @param {Array} itersectionIds Идентификаторы пересекающихся уточнений во всех баннерах
     * @param {Object[]} selectedCallouts Выбранные уточнения
     * @returns {Object}
     * @private
     */
    _mergeCallouts: function(prevValue, itersectionIds, selectedCallouts) {
        var selectedIds = selectedCallouts.map(this._getAdditionsItemId, this),
            prevValueIds = prevValue.map(this._getAdditionsItemId, this),
            // Набор уточнений с которых сняли выбор, и которые следует удалить
            calloutsIdsToRemoveMap = this._getObjectMapForFilter(u._.difference(itersectionIds, selectedIds)),
            // Набор новых уточнений, которые пользователь выбрал, и которые следует добавить
            calloutsIdsToAddMap = this._getObjectMapForFilter(u._.difference(selectedIds, prevValueIds));

        return prevValue
            // удаляем лишние
            .filter(function(callout) { return !calloutsIdsToRemoveMap[callout.additions_item_id] })
            // добавляем новые
            .concat(selectedCallouts.filter(function(callout) {
                return calloutsIdsToAddMap[callout.additions_item_id];
            }));
    }

});
