BEM.MODEL.decl({ model: 'b-callouts-selector_mode_multi', baseModel: 'b-callouts-selector' }, {

    // Набор выбранных уточнений в баннерах
    calloutsKits: {
        type: 'array',
        default: []
    },

    // Набор идентификаторов выбранных уточнений баннеров
    calloutsIdsKits: {
        type: 'array',
        dependsFrom: 'calloutsKits',
        calculate: function() {
            return this.get('calloutsKits').map(function(callouts) {
                return callouts.map(function(callout) {
                    return callout.additions_item_id;
                });
            });
        },
        validation: {
            rules: {
                maxLength: {
                    text: u.pluralForms(
                        iget2(
                            'b-callouts-selector',
                            'dlya-odnogo-obyavleniya-nelzya',
                            'Для одного объявления нельзя указать более {foo} {уточнения|уточнений|уточнений}',
                            {
                                foo: u.consts('MAX_CALLOUTS_COUNT_ON_BANNER')
                            }
                        )),
                    validate: function(calloutsIdsKits) {
                        var selectedCallouts = this.get('selectedIds');

                        return !calloutsIdsKits.some(function(idsKits) {
                            return u._.union(selectedCallouts, idsKits).length >
                                u.consts('MAX_CALLOUTS_COUNT_ON_BANNER');
                        });
                    }
                }
            }
        }
    },

    // Идентификаторы уточений, которые пересекаются во всех баннерах
    calloutsIntersectionIds: {
        type: 'array',
        dependsFrom: 'calloutsIdsKits',
        calculate: function() {
            return u._.intersection.apply(u, this.get('calloutsIdsKits'))
        }
    },

    // Идентификаторы всех выбранных в баннерах уточнений
    allCalloutsIds: {
        type: 'array',
        dependsFrom: 'calloutsIdsKits',
        calculate: function() {
            return u._.unique(this.get('calloutsIdsKits').reduce(function(result, calloutsIds) {
                return result.concat(calloutsIds);
            }, []));
        }
    },

    // Количество отличающихся уточнений между уточнениями баннеров и выбранных в блоке
    diffCount: {
        type: 'number',
        calculate: function() {
            return u._.difference(this.get('allCalloutsIds') || [], this.get('selectedIds') || []).length
        },
        dependsFrom: ['allCalloutsIds', 'selectedIds']
    }

}, {

    /**
     * Очищает список выбранных уточнений в блоке
     */
    resetAll: function() {
        this.set('calloutsKits', this._getEmptyArrays(this.get('calloutsKits').length));

        this.__base.apply(this, arguments);
    },

    /**
     * Возвращает массив пустых массивов
     * @param {Number} length Необходимая длина массива
     * @returns {Array}
     * @private
     */
    _getEmptyArrays: function(length) {
        var result = [];

        while (length--) { result.push([]);}

        return result;
    }

});
