#b-callouts-selector#

##Описание##
Блок реализует две функциональности:
* Работа с уточнениями пользователя (уточнения хранятся на уровне пользователя)
    * Добавление
    * Удаление
* Выбор уточнений
    * к `одному баннеру` (пример в блоке `b-banner-callouts`)
    * к `нескольким баннерам`: для этого нужен модификатор `_mode_multi` (пример в массовых действиях в блоке `b-edit-groups-mass-actions`)

Для работы с блоком есть только два публичных метода:
    * `reset` - Сбрасывает предыдущее состояние и задает новое
    * `val` - Возвращает текущее значение

Блок ничего не знает о data-моделях баннеров, он:
* На вход получает набор уточнений
    * для `одного баннера` в метод `reset()` нужно передать объект с ключом `callouts` - массивом уточнений выбранных к баннеру
    * для `нескольких баннеров` в метод `reset()` нужно передать объект с ключом `calloutsKits` - массивом массивов уточнения выбранных к баннерам
* В процессе выбора пользователем уточнений (к баннеру, либо баннерам), сообщает есть ли изменения, через событие `change`
* На выходе возвращает модифицированный набор уточнений
    * для `одного баннера` результат в поле `callouts`
    * для `нескольких баннеров` результат в поле `calloutsKits`

Блок имеет следующие состояния:
    * Загрузка уточнений клиента – `_loading_yes`
    * Нет ни одного уточнения –`_selection_can-not-be`
    * Уточнения есть, но нет ни одного выбранного – `_selection_empty`
    * Есть выбранные уточнения (и они совпадают для `_mode_multi`) – `_selection_same`
    * Только для `_mode_multi`: Есть выбранные уточнения, но некоторые не совпадают – `_selection_some-different`
    * Только для `_mode_multi`: Есть выбранные уточнения, но ни одного общего – `_selection_fully-different`

Выглядит [вот так](https://jing.yandex-team.ru/files/cyn/Redaktirovanie_aktivnyh_objyavlenii_2016-04-05_11-36-00.png)

###Автор### 
[dima117a](https://staff.yandex-team.ru/dima117a)

###Ответственные###
* [dima117a](https://staff.yandex-team.ru/dima117a)
* [cyn](https://staff.yandex-team.ru/cyn)

###Где используется###
На мультиредактировании: для редактирования одного баннера и в массовых действия.
   
###Взаимодействие с другими блоками###
todo

##Пример##

`
var bemBlock = $(BEMHMTL.apply({ block: 'b-callouts-selector' })).bem('b-callouts-selector');

bemBlock.reset({
    callouts: [{
        additions_item_id: '13791',
        callout_text: 'Уточнение',
        status_moderate: 'Ready'
    }]
});

bemBlock.on('change', function(e, data) { console.log(data.isChanged()); })

bemBlock.val();
`

##Задачи##
* https://st.yandex-team.ru/DIRECT-50262
* https://st.yandex-team.ru/DIRECT-52621
