BEM.MODEL.decl('b-callouts-selector', {

    // Полный список уточнений
    list: {
        type: 'models-list',
        modelName: 'b-callouts-selector-item'
    },

    // Наличие доступных для выбора уточнений
    haveAvailable: {
        type: 'boolean',
        dependsFrom: 'list',
        calculate: function() {
            return !!this.get('list', 'raw').length
        }
    },

    // Список идентификаторов выбранных уточнений
    selectedIds: {
        type: 'array',
        default: [],
        dependsFrom: 'list',
        calculate: function() {
            return this.getSelected().map(function(callout) {
                return callout.get('additions_item_id');
            });
        },
        validation: {
            rules: {
                maxLength: {
                    text: u.pluralForms(
                        iget2(
                            'b-callouts-selector',
                            'dlya-odnogo-obyavleniya-nelzya',
                            'Для одного объявления нельзя указать более {foo} {уточнения|уточнений|уточнений}',
                            {
                                foo: u.consts('MAX_CALLOUTS_COUNT_ON_BANNER')
                            }
                        )),
                    validate: function(selectedIds) {
                        // В модели multi валидация будет проходить в поле calloutsIdsKits
                        return this.name === 'b-callouts-selector' ?
                            selectedIds.length <= u.consts('MAX_CALLOUTS_COUNT_ON_BANNER') :
                            true;
                    }
                }
            }
        }
    },

    // Суммарное количество символов выбранных уточнений
    selectedTextLength: {
        type: 'number',
        calculate: function() {
            var list = this.get('list');

            return this.get('selectedIds').reduce(function(prev, calloutId) {
                return prev + list.getById(calloutId).get('callout_text').length;
            }, 0);
        },
        dependsFrom: 'selectedIds'
    },

    // Наличие выбранных уточнений в блоке
    haveSelected: {
        type: 'boolean',
        dependsFrom: 'selectedIds',
        calculate: function() {
            return !!this.get('selectedIds').length
        }
    },

    // Флаг готовности модели
    inited: {
        type: 'boolean',
        default: false
    }

}, {

    /**
     * Возвращает набор моделей выбранных уточнений
     * @returns {BEM.MODEL[]}
     */
    getSelected: function() {
        return this.get('list').filter(function(el) {
            return el.get('selected');
        });
    },

    /**
     * Возвращает модель уточнения по тексту
     * @param {String} text
     * @returns {BEM.MODEL|undefined}
     */
    getCalloutByText: function(text) {
        return this.get('list').where({ callout_text: text })[0];
    },

    /**
     * Добавляет новое уточнение
     * @param {Object} callout Уточнение
     * @param {String} callout.additions_item_id Идентификатор
     * @param {String} callout.callout_text Текст
     * @param {String} callout.status_moderate Статус модерации
     * @returns {Boolean}
     */
    addNewCallout: function(callout) {
        this.get('list').add({
            additions_item_id: callout.additions_item_id,
            callout_text: callout.callout_text,
            status_moderate: callout.status_moderate || 'Ready',
            selected: true
        });

        return true;
    },

    /**
     * Удаляет из списка уточнение с указанным ID
     * @param {Number|String} id - идентификатор уточнения
     */
    deleteCalloutById: function(id) {
        this.get('list').getById(id).destruct();
    },

    /**
     * Очищает список выбранных в блоке и выбранных ранее уточнений
     */
    resetAll: function() {
        this.get('list').forEach(function(el) {
            el.set('selected', false);
        });
    },

    /**
     * Устанавливает заданное значение свойства selected для заданных id
     * @param {Boolean} value значение свойства selected
     * @param {String} id фильтр по id
     * @private
     */
    setCalloutSelection: function(value, id) {
        this.get('list').getById(id).set('selected', !!value);
    }

});

BEM.MODEL.decl('b-callouts-selector-item', {

    // Идентификатор уточнения
    additions_item_id: { type: 'id' },

    // Текст уточнения
    callout_text: 'string',

    // Статус модерации
    status_moderate: 'string',

    // Флаг выбранности
    selected: {
        type: 'boolean',
        default: false,
        internal: true
    }

});
