/**
 * {{ deal_id: string, name: string }[]} this.ctx.value Привязанные сделки
 * {string} this.ctx.cid Номер кампании
 * {string} this.ctx.agencyLogin Логин агентства
 */
block('b-campaign-deals')(

    js()(
        function() {
            return u._.pick(this.ctx, ['value', 'agencyLogin', 'cid']);
        },

        mod('readonly', 'yes')(false)
    ),

    content()(function() {
        return [
            { elem: 'value', value: this.ctx.value },
            { elem: 'change-button', value: this.ctx.value }
        ];
    }),

    elem('change-button')(
        replace()(function() {
            return {
                block: 'button',
                mods: {
                    disabled: this.mods.disabled,
                    pseudo: 'yes',
                    theme: 'normal',
                    size: 's'
                },
                mix: [
                    { block: 'b-campaign-deals', elem: 'change-button' },
                    {
                        block: 'b-metrika2',
                        js: {
                            blockName: 'button',
                            target: 'CAMPAIGN_LIST_OF_DEALS',
                            event: 'click'
                        }
                    }
                ],
                content: iget2('b-campaign-deals', 'change-deals', 'Изменить')
            };
        }),

        mod('readonly', 'yes').def()('')
    ),

    elem('show-all')(
        mod('readonly', 'yes').replace()(function() {
            return {
                block: 'dropdown2',
                mods: { switcher: 'button2', theme: 'normal', size: 's' },
                mix: { block: 'b-campaign-deals', elem: 'show-all' },
                switcher: iget2('b-campaign-deals', 'show-deals', 'Посмотреть'),
                popup: {
                    block: 'popup2',
                    content: {
                        block: 'b-campaign-deals',
                        elem: 'show-all-deals',
                        content: (this.ctx.value || []).map(function(dealItem) {
                            return {
                                block: 'b-campaign-deals',
                                elem: 'show-all-deal-name',
                                content: dealItem.name
                            }
                        })
                    }
                }
            };
        }),

        mod('readonly', 'no').def()('')
    ),

    elem('show-all-deal-name').content()(function() {
        return ' &ndash; ' + this.ctx.content;
    }),

    elem('value').content()(
        function() {
            var dealsCount = (this.ctx.value || []).length;

            return [
                iget2('b-campaign-deals', 'linked-active-deals-count', 'К кампании {linked} {dealsCount} {active} {deals}', {
                    dealsCount: dealsCount,
                    linked: u.pluralizeWord([
                        iget2('b-campaign-deals', 'priviazana', 'привязана'),
                        iget2('b-campaign-deals', 'priviazano', 'привязано'),
                        iget2('b-campaign-deals', 'priviazano', 'привязано'),
                        iget2('b-campaign-deals', 'priviazano', 'привязано')
                    ], dealsCount),
                    active: u.pluralizeWord([
                        iget2('b-campaign-deals', 'activnaja', 'активная'),
                        iget2('b-campaign-deals', 'activnie', 'активные'),
                        iget2('b-campaign-deals', 'activnih', 'активных'),
                        iget2('b-campaign-deals', 'activnih', 'активных')
                    ], dealsCount),
                    deals: u.pluralizeWord([
                        iget2('b-campaign-deals', 'sdelka', 'сделка'),
                        iget2('b-campaign-deals', 'sdelki', 'сделки'),
                        iget2('b-campaign-deals', 'sdelok', 'сделок'),
                        iget2('b-campaign-deals', 'sdelki', 'сделки')
                    ], dealsCount),
                    context: 'К кампании привязана 1 активная сделка'
                }),
                { elem: 'show-all', value: this.ctx.value }
            ];
        },

        match(function() { return !(this.ctx.value || []).length })(function() {
            return iget2('b-campaign-deals', 'deals-does-not-exist', 'Нет привязанных сделок');
        })
    )

);
