BEM.DOM.decl('b-campaign-deals', {

    onSetMod: {

        js: function() {
            this._params = this.params;
        }

    },

    /**
     * Обновляет контент блока с новым значением
     * @param {{ deal_id: string, name: string }[]} value
     * @private
     */
    _updateContent: function(value) {
        this._updateElem('value', value);

        if (this.elem('change-button').length) {
            this._updateElem('change-button', value);
        }
    },

    /**
     * Рендерит заново элемент
     * @param {string} elemName
     * @param {{ deal_id: string, name: string }[]} value
     * @private
     */
    _updateElem: function(elemName, value) {
        BEM.DOM.replace(
            this.elem(elemName),
            BEMHTML.apply({
                block: 'b-campaign-deals',
                mods: u._.omit(this.getMods(), 'js'),
                elem: elemName,
                value: value
            })
        );

        this.dropElemCache(elemName)
    },

    /**
     * Открывает и инициализирует попап сделок
     * @private
     */
    _onChangeClick: function() {
        var popupDecorator = this._popupDecorator = BEM.blocks['b-modal-popup-decorator'].create(
                false,
                { bodyScroll: false }
            ),
            subMan = this._subMan = BEM.create('i-subscription-manager'),
            dealsPopup = popupDecorator
                .setPopupContent({ block: 'deals-selector-popup' })
                .initialize(u._.pick(this._params, ['value', 'agencyLogin', 'cid']));

        subMan
            .on(dealsPopup, 'save', this._onDealsSelectorSave, this)
            .on(dealsPopup, 'cancel', this._onDealSelectorCancel, this)
            .on(popupDecorator, 'close-blocked', this._onDealsSelectorCloseBlocked, this)
            .on(popupDecorator, 'close', this._onDealsSelectorClose, this);

        popupDecorator.show();
    },

    /**
     * Обработчик удачного изменения сделок из попапа
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {{ name: string, deal_id: string }[]} data.value
     * @private
     */
    _onDealsSelectorSave: function(e, data) {
        this._updateContent(this._params.value = data.value);

        if (!data.hasErrors) {
            this._popupDecorator.hide({ force: true });
        }
    },

    /**
     * Обработчик отмены в попапе
     * @private
     */
    _onDealSelectorCancel: function() {
        this._popupDecorator.hide({ force: true });
    },

    /**
     * Обработчик закрытия попапа без сохранения
     * @private
     */
    _onDealsSelectorCloseBlocked: function() {
        var popupDecorator = this._popupDecorator;

        BEM.blocks['b-confirm'].open({
            message: iget2('b-campaign-deals', 'close-without-saving', 'Изменения не будут сохранены. Продолжить?'),
            fromPopup: popupDecorator.getPopup(),
            onYes: function() {
                popupDecorator.hide({ force: true });
            }
        });
    },

    /**
     * Обработчик закрытия попапа сделок
     * @private
     */
    _onDealsSelectorClose: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this._popupDecorator.destruct();
    },

    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function(e, data) {
            if (this.elem('change-button').is(e.block.domElem)) {
                this._onChangeClick(e, data);
            }
        })
    }

});
