(function() {
    var changedIds = {},
        MODELS_TYPES = ['phrase', 'retargeting', 'interest', 'relevance-match', 'dynamic-condition', 'feed-filter'],
        confirm = BEM.blocks['b-confirm'],
        phraseHelper,
        WARNING_MESSAGE = '';

    BEM.DOM.decl('b-campaign-edit-panel', {
        onSetMod: {
            js: function() {
                this.__self.instance = this;

                var onModelChangeDebounced = $.debounce(this.onModelsChanged, 100, this);

                WARNING_MESSAGE = iget2(
                    'b-campaign-edit-panel',
                    'eta-stranica-prosit-vas',
                    'Эта страница просит вас подтвердить, что вы хотите уйти — при этом введённые вами данные могут не сохраниться.'
                );

                this.saveBtn = this.findBlockOn('save-prices', 'button');
                this.saveBtn && this.saveBtn.on('click', this.save, this);
                phraseHelper = BEM.blocks['i-phrases-prices-helper'].getInstance('all', this.getCampModel());
                //alkaline@todo: отказаться от eachField в пользу eachModelType
                phraseHelper.eachField(function(fieldName, type) {
                    BEM.MODEL.on(this.getModelParams(type), fieldName, 'change', onModelChangeDebounced, this);
                }, this);

                this.bindToWin('beforeunload', this._onBeforeUnload);
            }
        },

        /**
         * Обработчик события `beforeunload` на `window`
         * @return {string}
         * @private
         */
        _onBeforeUnload: function() {
            if (phraseHelper.hasChangedModels()) {
                return WARNING_MESSAGE;
            }
        },

        /**
         * Убираем подписку beforeunload
         */
        unbindLeave: function() {
            this.unbindFromWin('beforeunload', this._onBeforeUnload);
        },

        /**
         * Какая-то из моделей фраз изменилась
         * @returns {BEM}
         */
        onModelsChanged: function() {
            return this.updateSaveBtnState();
        },

        /**
         * Обновляем модификатор кнопки сохранения
         * @returns {BEM}
         */
        updateSaveBtnState: function(isProcess) {
            if (isProcess) {
                this.saveBtn
                    .setMod('disabled', 'yes')
                    .elem('text').text(iget2('b-campaign-edit-panel', 'sohranyaetsya', 'Сохраняется...'));
            } else {
                var hasChanged = phraseHelper.hasChangedModels();

                this.saveBtn
                    .setMod('disabled', hasChanged ? '' : 'yes')
                    .setMod('theme', hasChanged ? 'action' : 'normal')
                    .elem('text').text(hasChanged ? iget2('b-campaign-edit-panel', 'sohranit', 'Сохранить') : iget2('b-campaign-edit-panel', 'sohraneno', 'Сохранено'));
            }

            this.setMod(this.elem('save'), 'active', 'yes');

            return this;
        },

        /**
         * Возвращает модель кампании для данной страницы
         * @returns {BEM.MODEL}
         */
        getCampModel: function() {
            return this._campModel || (this._campModel = BEM.MODEL.getOne(this.params.modelParams))
        },

        /**
         * Возвращает начальный id фразы, с которым была проинициализирована модель
         * по новому id, сохраненному на сервере
         * @param {String|Number} pid id сохраненный на сервере
         * @returns {String}
         */
        getModelId: function(pid) {
            return changedIds[pid] || pid;
        },

        updateSuspended: function() {
            //todo - updateSuspended
            //убрать переключатель на лёгкий интерфейс
        },

        /**
         * Были ли во время последней правки изменены ставки
         * @returns {boolean}
         */
        isPricesChanged: function() {
            // в одном (любом) из типов что то поменялось про цену
            return MODELS_TYPES.some(function(type) {
                var changes = this.changes && this.changes[type] || {},
                    props = ({
                        'feed-filter': ['price_cpc', 'price_cpa']
                    })[type] || ['price', 'price_context'];

                return Object.keys(changes).some(function(adgroupId) {
                    var edited = (changes[adgroupId] || {}).edited || {};

                    // было изменено одно из ценовых полей в каком-либо объекте
                    return Object.keys(edited).some(function(pid) {
                        return props.some(function(prop) { return edited[pid][prop]; });
                    });
                });
            }, this);
        },

        /**
         * Проверяем, идут ли показы компании
         * @returns {boolean}
         */
        isCampShows: function() {
            return this.getCampModel().get('isCampShows');
        },

        /**
         * Удаляем модели фраз после того, как удаление успешно прошло на сервере
         * @returns {BEM}
         */
        updateDeleted: function() {
            var changes,
                data,
                model;

            MODELS_TYPES.forEach(function(type) {
                changes = this.clientChanges[type];
                changes && Object.keys(changes).forEach(function(adgroupId) {
                    data = changes[adgroupId];

                    if (data.deleted && data.deleted.length) {
                        data.deleted.forEach(function(pid) {

                            switch (type) {
                                case 'relevance-match':
                                    // у автотаргетинга id модели совпадает не с pid, а с groupId
                                    // потому что он 1 на группу
                                    model = this.getModel(type, adgroupId, adgroupId);
                                    // просто удаление модели не катит, потому-что при getOrCreate достаются данные из BEM.MODEL.modelsData
                                    BEM.MODEL.modelsData[model.name][model._path].bid_id = '0';
                                    model.destruct();
                                    break;
                                case 'retargeting':
                                    // удаляем по ret_id, а модель ищем по ret_con_id
                                    this.getModel(type, adgroupId, this._retIdsHash[pid]).destruct();
                                    break;
                                default:
                                    this.getModel(type, adgroupId, pid).destruct();
                            }

                        }, this);
                    }

                }, this);
            }, this);

            return this;
        },

        /**
         * Вызывает метод fix на всех моделях, которые были изменены
         * @returns {BEM}
         */
        fixData: function() {
            phraseHelper.eachModel(function(model) {
                model.fix();
            });

            return this;
        },

        /**
         * Возвращает модель фразы/категорию/условие ретаргетинга/фильтра
         * @param {String} type тип модели
         * @param {String} adgroupId идентификатор группы
         * @param {String} id идентификатор фразы/категории/условия ретаргетинга/фильтра
         * @returns {BEM.MODEL}
         */
        getModel: function(type, adgroupId, id) {
            return BEM.MODEL.getOrCreate(this.getModelParams(type, id, adgroupId));
        },

        /**
         * Возвращает параметры модели по указанному типу
         * @param {String} type тип модели
         * @param {String} [id] идентификатор фразы/категории/условия ретаргетинга/фильтра
         * @param {String} [adgroupId] идентификатор группы
         * @return {Object}
         */
        getModelParams: function(type, id, adgroupId) {
            var modelNames = {
                    phrase: 'm-phrase-bidable',
                    interest: 'm-interest-bidable',
                    retargeting: 'm-retargeting-bidable',
                    'relevance-match': 'm-relevance-match'
                },
                modelParams = ({
                    'feed-filter': { name: 'dm-feed-filter' },
                    'dynamic-condition': { name: 'dm-dynamic-condition' }
                })[type] || {
                    name: modelNames[type] || 'm-retargeting-bidable',
                    parentName: this.getCampModel().getChildGroupModelName(),
                    parentId: adgroupId || '*'
                };

            id && (modelParams.id = this.getModelId(id));

            return modelParams;
        },

        /**
         * Если пользователь пытается сохранить новые изменения,
         * считаем старую корректировку минус-слов принятой, перекидываем
         * данные в обычные минус-слова, освобождая phrase_unglued_suffix
         * для новых возможных корректировок
         * @returns {BEM}
         */
        saveOldCorrections: function() {
            var model;

            this.corrections && this.corrections.unglued && this.corrections.unglued.forEach(function(correction) {
                model = this.getModel('phrase', correction.adgroup_id, correction.id);

                model.update({
                    minus_words: model.get('minus_words') +
                        (model.get('unglued') ? model.get('phrase_unglued_suffix').slice(1) : ''),
                    phrase_unglued_suffix: '',
                    unglued: 0
                }).fix();

            }, this);

            this.corrections && this.corrections['stopword-fixated'] && this.corrections['stopword-fixated']
                .forEach(function(correction) {
                    model = this.getModel('phrase', correction.adgroup_id, correction.id);

                    model.update({
                        key_words: model.get('stopword_fixated') ?
                            model.get('key_words_fix_on') :
                            model.get('key_words_fix_off'),
                        key_words_fix_on: '',
                        key_words_fix_off: '',
                        stopword_fixated: 0
                    }).fix();

                }, this);

            this.corrections = { unglued: [], 'stopword-fixated': [] }; // эту структуру приходится повторять

            return this;
        },

        /**
         * @typedef {Object} BidableSaveError
         * @property {String} text текст ошибки
         * @property {Number} [adgroupId] группа, которой относится ошибка
         */

        /**
         * Обрабатывает ошибки сохранения и
         * @param {BidableSaveError[]} errors массив ошибок
         * @param {Function} onSaveSuccess колбек
         */
        _onSaveDone: function(errors, onSaveSuccess) {
            if (errors.length) {
                this.getCampModel().trigger('error', errors);
                this.updateSaveBtnState();
            } else {
                this.updateDeleted();
                this.updateSuspended();

                this.fixData();
                this.updateSaveBtnState();
                this.isPricesChanged() && confirm.alert(
                    [
                        iget2('b-campaign-edit-panel', 'vashi-stavki-sohraneny', 'Ваши ставки сохранены.'),
                        iget2('b-campaign-edit-panel', 'aktivizaciya-izmeneniy-mozhet-zanimat', 'Активизация изменений может занимать до 30 минут.'),
                        this.isCampShows() && this.declinedBanner && iget2(
                            'b-campaign-edit-panel',
                            'dlya-otklonennyh-bannerov-izmeneniya',
                            'Для отклоненных баннеров изменения ставки применятся после принятия баннера модератором.'
                        )
                    ]);

                if (typeof onSaveSuccess == 'function') {
                    onSaveSuccess.apply(this);
                }
            }
        },

        /**
         * Создаёт BEM-блок i-request
         * @returns {BEM}
         */
        _getRequest: function() {
            return BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                cache: false,
                dataType: 'json',
                type: 'POST',
                callbackCtx: this
            });
        },

        /**
         * Отправляет ajax-запросы на сохранение
         * @returns {$.Deferred}
         */
        sendSaveRequest: function(onSaveSuccess) {
            BEM.blocks['b-groups-list'].initPhrasesLists(this.changedGroups);
            BEM.blocks['b-groups-list'].initDynamicMediaFilters(this.changedGroups);

            var saveRequests = [
                this.sendConditionsRequest(),
                this.sendMediaFiltersRequest(),
                this.sendPhrasesAndRetargetingsRequest()
            ];

            $.when.apply($, saveRequests)
                .then(function() {
                    var errors = Array.prototype.concat.apply([], arguments); //объединяем массивы ошибок от разных запросов в один

                    this._onSaveDone(errors, onSaveSuccess);
                }.bind(this))
                .fail(function() {
                    this._onSaveDone([{ text: iget2('b-campaign-edit-panel', 'ne-udalos-sohranit-dannye', 'Не удалось сохранить данные. Пожалуйста, попробуйте позже.') }]);
                }.bind(this));

            return this;
        },

        /**
         * Отправляет ajax-запрос на сохранение условий нацеливания динамической группы
         * @returns {$.Deferred<BidableSaveError[]>}
         */
        sendConditionsRequest: function() {
            var changes = this.changes['dynamic-condition'],
                result = $.Deferred();

            if ($.isEmptyObject(changes)) {
                return $.when([]);
            }

            var campModel = this.getCampModel(),
                params = {
                    cid: campModel.get('cid'),
                    ulogin: u.consts('ulogin'),
                    cmd: 'ajaxEditDynamicConditions'
                };

            params['json_adgroup_dynamic_conditions'] = JSON.stringify(changes);

            this._getRequest().get(
                params, function(data) {
                    result.resolve(this._onConditionsSuccess(data));
                },
                function() {
                    result.reject();
                });

            return result.promise();
        },

        /**
         * Обрабатывает успешный ответ на запрос сохранения условий нацеливания и возвращает массив ошибок
         * @param {Object} data
         * @returns {BidableSaveError[]}
         */
        _onConditionsSuccess: function(data) {
            var errors = [];

            if (data.error) {
                errors.push({ text: data.error });
            } else {
                Object.keys(data).map(function(adgroupId) {
                    var groupData = data[adgroupId];

                    if (groupData.errors) {
                        errors.push({ adgroupId: adgroupId, text: groupData.errors.join(', ') });
                    }
                }, this);
            }

            return errors;
        },

        /**
         * Отправляет ajax-запрос на сохранение фильтров ДМО группы
         * @returns {$.Deferred<BidableSaveError[]>}
         */
        sendMediaFiltersRequest: function() {
            var changes = this.changes['feed-filter'],
                result = $.Deferred();

            if ($.isEmptyObject(changes)) {
                return $.when([]);
            }

            var campModel = this.getCampModel(),
                params = {
                    cid: campModel.get('cid'),
                    ulogin: u.consts('ulogin'),
                    cmd: u.campaign.getSaveFilterAjaxCmd(campModel.get('mediaType')),
                    flat_errors: 1
                };

            params[u.campaign.getSaveFilterAjaxParamName(campModel.get('mediaType'))] = JSON.stringify(changes);

            this._getRequest().get(
                params, function(data) {
                    result.resolve(this._onMediaFiltersSuccess(data));
                },
                function() {
                    result.reject();
                });

            return result.promise();
        },

        /**
         * Обрабатывает успешный ответ на запрос сохранения фильтров и возвращает массив ошибок
         * @param {Object} data
         * @returns {BidableSaveError[]}
         */
        _onMediaFiltersSuccess: function(data) {
            var errors = [],
                //для некоторых типов ошибок мы не показываем данные, пришедшие в data
                SHOW_ONLY_DESCRIPTION = ['LimitExceeded', 'MaxLength'];

            // при смене идентификаторов фильтров на сервере
            // обновляем реальные идентификаторы в dm моделях
            data.ids_map && BEM.MODEL.get(this.getModelParams('feed-filter')).forEach(function(model) {
                var newRealId = +data.ids_map[model.get('real_filter_id')];

                newRealId && model.set('real_filter_id', newRealId);
            });

            if (data.error) {
                errors.push({ text: data.error });
            } else {
                Object.keys(data).forEach(function(adgroupId) {
                    var groupData = data[adgroupId];

                    groupData.errors && groupData.errors.forEach(function(err) {
                        var text = err.description +
                                (SHOW_ONLY_DESCRIPTION.indexOf(err.name) == -1 && err._data && err._data.length ?
                                    ' (' + err._data + ')' :
                                    ''),
                            lookupId = err._performance_filters_id || err._dynamic_conditions_id,
                            model = BEM.MODEL.get({ name: 'dm-feed-filter' }).filter(function(model) {
                                return model.get('real_filter_id') == lookupId;
                            }).pop();

                        errors.push({
                            adgroupId: adgroupId,
                            text: text,
                            phraseModelId: err._performance_filters_id || err._dynamic_conditions_id,
                            type: 'feed-filter',
                            phrase: model.get('filter_name')
                        });
                    });

                }, this);
            }

            return errors;
        },

        /**
         * Отправляет ajax-запрос на сохранение фраз и условий ретаргетинга
         * @returns {$.Deferred<BidableSaveError[]>}
         */
        sendPhrasesAndRetargetingsRequest: function() {
            var changes = this.changes,
                totalPhrases = Object.keys(changes.phrase || {}).reduce(function(acc, next) {
                    return acc + Object.keys(changes.phrase[next].edited || {}).length;
                }, 0),
                retargetings = changes.retargeting,
                result = $.Deferred(),
                campModel = this.getCampModel(),
                platform = campModel.get('platform'),
                params = {
                    cid: campModel.get('cid'),
                    ulogin: u.consts('ulogin'),
                    cmd: 'ajaxUpdateShowConditions'
                };

            if (u._.isEmpty(changes.phrase) && u._.isEmpty(retargetings) &&
                u._.isEmpty(changes.interest) && u._.isEmpty(changes['relevance-match'])) {
                return $.when([]);
            }

            params.json_phrases = JSON.stringify(changes.phrase);

            if (u.consts('isSearchRetargetingEnabled')) {
                params.json_adgroup_retargetings = platform === 'context' ? JSON.stringify(retargetings) : {};

                params.json_adgroup_search_retargetings = platform === 'search' ? JSON.stringify(retargetings) : {};
            } else {
                params.json_adgroup_retargetings = JSON.stringify(retargetings);
            }

            params.json_adgroup_target_interests = JSON.stringify(changes.interest);
            params.json_relevance_match = JSON.stringify(changes['relevance-match']);

            this._getRequest().get(
                params,
                function(data) {
                    result.resolve(this._onPhrasesAndRetargetingsSuccess(data));
                }.bind(this),
                function() {
                    result.reject();
                },
                {
                    // таймаут - 20 секунд на фразу
                    // @see https://st.yandex-team.ru/DIRECT-30483?#1397724395000
                    timeout: totalPhrases * 20000
                });

            return result.promise();
        },

        /**
         * Обрабатывает успешный ответ на запрос сохранения фраз и ретаргетингов и возвращает массив ошибок
         * @param {Object} data - данные, возвращенные сервером
         * @returns {BidableSaveError[]}
         */
        _onPhrasesAndRetargetingsSuccess: function(data) {
            var groupData,
                phrasesData,
                bannersData,
                phraseData,
                model,
                errors = [];

            this.saveOldCorrections();
            this.corrections = { unglued: [], 'stopword-fixated': [] }; // эту структуру приходится повторять

            // были ли изменения по ставкам для фраз в баннерах, которые отклонены (если хотя бы один отклонен - true)
            this.declinedBanner = false;

            //ошибка не привязанная ни к какому конкретному баннеру
            if (data.error) {
                errors.push({ text: data.error });
            } else {
                Object.keys(data).map(function(adgroupId) {
                    groupData = data[adgroupId];

                    phrasesData = groupData.phrases;
                    bannersData = groupData.banners;

                    if (groupData.errors) {
                        errors.push({ adgroupId: adgroupId, text: groupData.errors.join(', ') });
                        return true;
                    }

                    var groupModel = this.getCampModel().getChildGroupById(adgroupId);

                    bannersData && Object.keys(bannersData).map(function(bannerId) {
                        var bannerModel = groupModel.getBannerByModelId(bannerId);

                        bannerModel.update(bannersData[bannerId]);

                         // Если хотя бы один баннер отклонен - ставим флаг
                        bannerModel.get('declined_show') && (this.declinedBanner = true);
                    }, this);

                    phrasesData && Object.keys(phrasesData).map(function(pid) {
                        phraseData = phrasesData[pid];
                        //id фразы мог измениться в процессе сохранений
                        if (phraseData.new_id) {
                            changedIds[phraseData.new_id] = this.getModelId(pid);
                            phraseData.id = phraseData.new_id;
                        }

                        /*jshint -W018*/
                        phraseData.is_suspended = !!+phraseData.is_suspended;

                        model = this.getModel('phrase', adgroupId, pid);

                        //DIRECT-30422 - если пришли из мониторинга, то сервер присылает информацию об изменении фраз, которые
                        //могут не отображаться на странице
                        if (!model) return;

                        if (phraseData.dublicate) {
                            BEM.MODEL.destruct(model);
                        } else {
                            //нужно для определения модели по данным в corrections, т.к. id фразы меняется в процессе правок
                            phraseData.modelId = this.getModelId(pid);
                            phraseData.minus_words = u.phraseFormatter.getMinusWords(phraseData.phrase);
                            phraseData.key_words = u.phraseFormatter.getKeyWords(phraseData.phrase);

                            if (phraseData.phrase_unglued_suffix || phraseData.fixation && phraseData.fixation.length) {
                                phraseData.adgroup_id = adgroupId;
                            }

                            if (phraseData.phrase_unglued_suffix) {
                                phraseData.unglued = 1;
                                this.corrections.unglued.push(phraseData);
                            }

                            /*jshint -W018*/
                            phraseData.autobroker = !!+phraseData.autobroker;
                            phraseData.is_suspended = !!+phraseData.is_suspended;

                            if (phraseData.fixation && phraseData.fixation.length) {
                                phraseData.stopword_fixated = 1;
                                phraseData.key_words_fix_on = phraseData.key_words;
                                phraseData.key_words_fix_off = u.phraseFormatter.getFixOff(
                                    phraseData.fixation,
                                    phraseData.key_words
                                );
                                this.corrections['stopword-fixated'].push(phraseData);
                            }

                            //@see DIRECT-34642
                            //при обновлении идентификатора фразы, новый идентификатор приходит в параметре new_id
                            if (phraseData.new_id) {
                                phraseData.id = phraseData.new_id;
                            }

                            //fix DIRECT-26083, с сервера приходят неправильные данные но пока ставим заплатку на клиенте
                            if (phraseData.price_context == 0) delete phraseData.price_context;

                            //обновляем модель. Не можем передать в update {isInit: true} потому что фразы слушают change
                            model.update(phraseData, { source: this });
                        }
                    }, this);

                }, this);
            }

            if (this.corrections.unglued.length || this.corrections['stopword-fixated'].length) {
                this.getCampModel().trigger('corrections', this.corrections);
            }

            return errors;
        },

        /**
         * Откатывает изменения в моделях
         * @returns {BEM}
         */
        rollback: function() {
            phraseHelper.eachModel(function(model, type) {
                if (phraseHelper.isModelChanged(model, type)) {
                    model.rollback();
                }
            }, this);

            return this;

        },

        /**
         * Складывает изменившиеся данные модели в хэш this.changes
         * @returns {BEM}
         */
        placeChanges: function() {
            var phraseId,
                itemId,
                changes,
                adgroupId,
                mainBid,
                campModel = this.getCampModel(),
                mediaType = campModel.get('mediaType'),
                platform = campModel.get('platform'),
                changedGroups = [];

            this.hasSuspended = false;
            //changes для отправки на сервер с bid в качестве ключа
            this.changes = {
                phrase: {},
                retargeting: {},
                interest: {},
                'relevance-match': {},
                'feed-filter': {},
                'dynamic-condition': {}
            };
            //changes для операция на клиенте с adgroupId в качестве ключа
            this.clientChanges = {};
            this.keyWordsForGroup = {};

            phraseHelper.eachModel(function(model, type) {
                if (!this.clientChanges[type]) this.clientChanges[type] = {};

                if (phraseHelper.isModelChanged(model, type)) {
                    if (type == 'dynamic-condition') {
                        adgroupId = model.get('adgroup_id');
                        itemId = model.get('dyn_id');
                        changes = this.changes[type];

                        changedGroups.indexOf(adgroupId) == -1 && changedGroups.push(adgroupId);
                        (!changes[adgroupId]) && (changes[adgroupId] = {});
                        model.get('is_suspended') && (this.hasSuspended = true);

                        if (model.get('is_deleted')) {
                            !changes[adgroupId].deleted && (changes[adgroupId].deleted = []);
                            changes[adgroupId].deleted.push(itemId);
                        } else {
                            !changes[adgroupId].edited && (changes[adgroupId].edited = {});
                            changes[adgroupId].edited[itemId] = this.getModelData(model, type);
                        }
                        this.clientChanges[type][adgroupId] = changes[adgroupId];
                    } else if (type == 'feed-filter') {
                        adgroupId = model.get('adgroup_id');
                        itemId = model.get('real_filter_id');
                        changes = this.changes[type];

                        changedGroups.indexOf(adgroupId) == -1 && changedGroups.push(adgroupId);
                        (!changes[adgroupId]) && (changes[adgroupId] = {});
                        model.get('is_suspended') && (this.hasSuspended = true);

                        if (model.get('is_deleted')) {
                            !changes[adgroupId].deleted && (changes[adgroupId].deleted = []);
                            changes[adgroupId].deleted.push(itemId);
                        } else {
                            !changes[adgroupId].edited && (changes[adgroupId].edited = {});
                            changes[adgroupId].edited[itemId] = this.getModelData(model, type);
                        }
                        this.clientChanges[type][adgroupId] = changes[adgroupId];
                    } else {
                        adgroupId = model.get('adgroup_id');

                        switch (type) {
                            case 'retargeting':
                                phraseId = model.get('ret_id');
                                this._retIdsHash = this._retIdsHash || {};
                                this._retIdsHash[phraseId] =
                                    u.consts('isSearchRetargetingEnabled') && platform === 'search' ?
                                        'search-' + model.get('ret_cond_id') :
                                        model.get('ret_cond_id');
                                break;
                            case 'interest':
                                phraseId = model.get('ret_id');
                                changedIds[phraseId] = model.id;
                                break;
                            case 'relevance-match':
                                phraseId = model.get('bid_id');
                                break;
                            default:
                                phraseId = model.get('id');
                                break;
                        }

                        changes = this.changes[type];

                        changedGroups.indexOf(adgroupId) == -1 && changedGroups.push(adgroupId);
                        (!changes[adgroupId]) && (changes[adgroupId] = {});
                        model.get('is_suspended') && (this.hasSuspended = true);

                        if (type == 'phrase' && model.isChanged('key_words')) {
                            (this.keyWordsForGroup[adgroupId] || (this.keyWordsForGroup[adgroupId] = []))
                                .push(model.get('key_words'));
                        }

                        if (model.get('is_deleted')) {
                            !changes[adgroupId].deleted && (changes[adgroupId].deleted = []);
                            changes[adgroupId].deleted.push(phraseId);
                        } else {
                            !changes[adgroupId].edited && (changes[adgroupId].edited = {});
                            changes[adgroupId].edited[phraseId] = this.getModelData(model, type);
                        }
                        this.clientChanges[type][adgroupId] = changes[adgroupId];
                    }
                    //DIRECT-51063, отправляем main_bid - а это всегда
                    //первый баннер массива, см b-campaign-group.bemtree.xjst
                    if (mediaType == 'text' || mediaType == 'mobile_content') {
                        mainBid = this.getCampModel()
                            .getChildGroupById(adgroupId)
                            .get('banners')
                            .getByIndex(0)
                            .get('modelId');
                        changes[adgroupId].main_bid = mainBid;
                    }
                }
            }, this);

            this.changedGroups = changedGroups;

            return this;
        },

        /**
         * Возвращает хэш с данными модели, которые изменились
         * @param {BEM.MODEL} model - модель
         * @param {String|'phrase'|'retargeting'|'interest'|'dynamic-condition'} type - тип модели
         * @returns {Object}
         */
        getModelData: function(model, type) {
            var data = {},
                campModel = this.getCampModel();

            phraseHelper.eachFieldType(type, function(fieldName) {
                if (model.isChanged(fieldName) && (fieldName !== 'is_deleted')) {
                    //alkaline@todo сделать полиморфное решение
                    if (type == 'dynamic-condition' && fieldName == 'condition') {
                        data[fieldName] = model.get(fieldName).map(function(x) { return x.toJSON(); });
                    } else if (type != 'feed-filter') {
                        data[fieldName] = model.get(fieldName);
                    }
                }
            }, this);

            if (type == 'feed-filter') {
                var modelData = model.provideData(),
                    priceFields = ['use_default_price', 'price_cpa', 'price_cpc'],
                    remapper = {
                        condition_tree: 'condition',
                        retargetings: 'retargeting',
                        interests: 'interest',
                        'relevance-match': 'relevance-match'
                    },
                    isFieldChanged = function(name) {
                        return u._.includes(priceFields, name) ?
                            priceFields.some(function(name) {
                                return model.isChanged(name);
                            }) :
                            true;
                    };

                phraseHelper.getSavedFields(type).forEach(function(name) {
                    var fieldName = remapper[name] || name;

                    isFieldChanged(name) && (data[fieldName] = modelData[fieldName]);
                });
            }

            //сервер не принимает true/false как значения автоброкера - только 0 или 1
            ['is_suspended'].forEach(function(name) {
                if (data[name] !== undefined) {
                    data[name] = +data[name];
                }
            });

            if (type == 'phrase' && (model.isChanged('minus_words') || model.isChanged('key_words'))) {
                delete data.minus_words;
                delete data.key_words;
                data.phrase = model.get('phrase');
            }

            return data;
        },

        /**
         * Удаляем информацию о коррекциях и ошибках (если пользователь начал изменять фразы)
         */
        clear: function() {
            this.saveOldCorrections();
            phraseHelper.dropCache();
            this.trigger('save');
        },

        /**
         * Пытаемся сохранить изменившиеся данные модели
         * @param {Function} [onSaveSuccess] выполнить если сохранение прошло успешно
         * @returns {BEM}
         */
        save: function(onSaveSuccess) {
            this.trigger('save');
            phraseHelper.dropCache();
            if (phraseHelper.validate()) {
                this
                    .updateSaveBtnState(true)
                    .placeChanges();

                if ($.isEmptyObject(this.keyWordsForGroup)) {
                    this.sendSaveRequest(onSaveSuccess);
                } else {
                    this.validateKeyWords(onSaveSuccess);
                }
            }

            return this;
        },

        /**
         * Проверяем ключевые фразы на пересечение с минус словами на объявление
         * @returns {this}
         */
        validateKeyWords: function(onSaveSuccess) {
            var campModel = this.getCampModel(),
                adgroupIds = [],
                params = {
                    cid: campModel.get('cid'),
                    cmd: 'ajaxCheckBannersMinusWords',
                    timeout: 110000, // 110 секунд
                    ulogin: u.consts('ulogin')
                };

            $.each(this.keyWordsForGroup, function(adgroupId, phrases) {
                adgroupIds.push(adgroupId);
                params['json_key_words-' + adgroupId] = JSON.stringify(phrases);
            });

            params.adgroup_ids = adgroupIds.join(',');

            this._getRequest().get(
                params,
                function(data) {
                    if (data.ok) {
                        this.sendSaveRequest(onSaveSuccess);
                    } else {
                        this._onSaveFailed(data);
                    }
                },
                function() {
                    confirm.alert(iget2('b-campaign-edit-panel', 'ne-udalos-sohranit-dannye', 'Не удалось сохранить данные. Пожалуйста, попробуйте позже.'));
                });

            return this;
        },

        _onSaveFailed: function(data) {
            confirm.open({
                message: data.problem.split('\n'),
                onYes: function() {
                    this.sendSaveRequest();
                },
                onNo: function() {
                    this.updateSaveBtnState(false);
                },
                textYes: iget2('b-campaign-edit-panel', 'ok', 'ОК'),
                textNo: iget2('b-campaign-edit-panel', 'otmena', 'Отмена')
            }, this);

        }
    }, {

        getInstance: function() {
            return this.instance;
        },

        /**
         * Вызывает один из колбеков-параметров, в зависимости от необходимости сохранить изменения в фразах и ответа на WARNING_MESSAGE
         * @param {Function} yesCallback колбек при необходимости сохранить изменения
         * @param {Function} noCallback колбек при отсутствии необходимости сохранить изменения
         * @param {BEM} callingPopup попап, из которого задается вопрос
         */
        canReload: function(yesCallback, noCallback, callingPopup) {
            if (phraseHelper.hasChangedModels(1)) {
                confirm.open({
                    message: WARNING_MESSAGE,
                    onYes: function() {
                        this.instance.unbindLeave();
                        yesCallback();
                    }.bind(this),
                    onNo: noCallback,
                    fromPopup: callingPopup
                });
            } else {
                this.instance.unbindLeave();
                yesCallback();
            }
        }

    });

})();
