/**
 * Блок, рисующий кнопку для ДРФ и скрытые инпуты для сохранения настройки
 */
block('b-campaign-email-notifications-adapter')(
    def()(function() {
        var emailPreviewLength = 100;

        return applyNext({
            emailPreviewLength: emailPreviewLength
        });
    }),

    js()(function() {
        return {
            ulogin: this.ctx.ulogin,
            notificationData: this.ctx.notificationData,
            emailPreviewLength: this.emailPreviewLength
        }
    }),

    content()(function() {
        var data = this.ctx.notificationData,
            attrs = {};

        if (data.email && data.email.length > this.emailPreviewLength) {
            attrs['title'] = u.escapeHTML(data.email);
        }

        return [
            {
                block: 'hint',
                mix: [{
                    block: 'b-campaign-email-notifications-adapter',
                    elem: 'hint'
                }].concat(this.ctx.hintMixes),
                content: {
                    block: 'hint-row',
                    content: data.email ? u.hellipCut(data.email, this.emailPreviewLength, u.escapeHTML) : '',
                    attrs: attrs
                }
            },
            {
                block: 'button',
                mods: { theme: 'normal', size: 's' },
                mix: {
                    block: 'b-campaign-email-notifications-adapter',
                    elem: 'opener'
                },
                content: data.email ? iget2('b-campaign-email-notifications-adapter', 'izmenit', 'Изменить') : iget2('b-campaign-email-notifications-adapter', 'dobavit', 'Добавить')
            },
            {
                elem: 'hidden-inputs',
                content: [
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-value' },
                        attrs: {
                            name: 'money_warning_value',
                            value: data.warning.value
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-email' },
                        attrs: {
                            name: 'email',
                            value: data.email
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-is-paused' },
                        attrs: {
                            name: 'email_notify_paused_by_day_budget',
                            value: +data.warning.isPaused
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-send-news' },
                        attrs: {
                            name: 'sendAccNews',
                            value: data.servicing.sendAccNews
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-offline-stat' },
                        attrs: {
                            name: 'offlineStatNotice',
                            value: +data.servicing.offlineStatNotice
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-send-warn' },
                        attrs: {
                            name: 'sendWarn',
                            value: data.warning.sendWarn
                        }
                    },
                    {
                        block: 'b-hidden',
                        mix: { block: 'b-campaign-email-notifications-adapter', elem: 'hidden-interval' },
                        attrs: {
                            name: 'warnPlaceInterval',
                            value: data.warning.interval
                        }
                    }
                ]
            }
        ];
    })
);
