BEM.DOM.decl('b-campaign-email-notifications-adapter', {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
            this._notificationData = this.params.notificationData;
            this._dataModel = BEM.MODEL.getOne(this._notificationData.dmParams);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    /**
     * показ попапа
     * @private
     */
    _showPopup: function() {
        this._initPopup();
        this._popupDecorator.show();
    },

    /**
     * Создает и кэширует попап настроек ДРФ
     * @private
     */
    _initPopup: function() {
        if (!this._popupDecorator) {
            this._popupDecorator = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $);
            this._notificationBlock = this._popupDecorator.setPopupContent({
                block: 'b-campaign-email-notifications',
                ulogin: this.params.ulogin,
                notificationData: this._notificationData
            });

            this._initEvents();
        }
    },

    /**
     * Инициализирует события на блоке
     * @private
     */
    _initEvents: function() {
        this._subMan
            .on(this._notificationBlock, 'save', function(e, data) {
                // сохранение параметров
                this._dataModel
                    .update(data)
                    .fix();

                this._updateHiddenFields(data);
                this._updateHint(data.email);
                this._updateBtn(!!data.email);

                this._notificationBlock.update(this._formData());
                this._popupDecorator.hide({ force: true });
            }, this)
            .on(this._notificationBlock, 'cancel', function() {
                // DIRECT-59123: отмена закрывает попапы с force
                this._notificationBlock.update(this._formData());
                this._popupDecorator.hide({ force: true });
            }, this)
            .on(this._popupDecorator, 'close-blocked', function(e) {
                // отмена при наличии изменений
                BEM.blocks['b-confirm'].open({
                    message: iget2('b-campaign-email-notifications-adapter', 'izmeneniya-ne-budut-sohraneny', 'Изменения не будут сохранены. Продолжить?'),
                    fromPopup: this._popupDecorator.getPopup(),
                    onYes: function() {
                        this._notificationBlock.update(this._formData());
                        this._popupDecorator.hide({ force: true });
                    }.bind(this)
                }, this);
            }, this);
    },

    /**
     * Обновляет value в скрытых инпутах по данным от блока ДРФ
     * @param {Object} data - данные от попапа ДРФ
     * @private
     */
    _updateHiddenFields: function(data) {
        this.elem('hidden-value').val(data.money_warning_value);
        this.elem('hidden-email').val(data.email);
        //vm-модель для checkbox (используется в b-email-notification)
        // плохо взаимодействует с типом flag (порождаются различные ошибки),
        // поэтому используем boolean. Но сервер требует значения 1 или 0, отсюда преобразования
        this.elem('hidden-is-paused').val(+data.email_notify_paused_by_day_budget);
        this.elem('hidden-send-news').val(+data.sendAccNews);
        this.elem('hidden-send-warn').val(+data.sendWarn);
        this.elem('hidden-offline-stat').val(+data.offlineStatNotice);
        this.elem('hidden-interval').val(data.warnPlaceInterval);
    },

    /**
     * Обновление хинта по данным из блока
     * @param {Object} email - email для уведомлений
     * @private
     */
    _updateHint: function(email) {
        var attrs = {};

        if (email && email.length > this.params.emailPreviewLength) {
            attrs['title'] = u.escapeHTML(email);
        }

        BEM.DOM.update(this.elem('hint'), email ?
            BEMHTML.apply({
                block: 'hint-row',
                content: u.hellipCut(email, this.params.emailPreviewLength, u.escapeHTML),
                attrs: attrs
            }) :
            iget2('b-campaign-email-notifications-adapter', 'ne-zadany', 'Не заданы')
        );
    },

    /**
     * Обновление надписи на кнопке
     * @param {Boolean} hasEmail - задан ли email
     * @private
     */
    _updateBtn: function(hasEmail) {
        this._getBtn().setText(hasEmail ? iget2('b-campaign-email-notifications-adapter', 'izmenit', 'Изменить') : iget2('b-campaign-email-notifications-adapter', 'dobavit', 'Добавить'))
    },

    /**
     * кэшируем кнопку
     * @returns {*|BEM}
     * @private
     */
    _getBtn: function() {
        return this._btn || (this._btn = this.findBlockOn('opener', 'button'));
    },

    /**
     * Формирование данных на основе dm-модели и сохраненных неизменных данных
     * @returns {*|{on, flag, domain, limit, rate, goalId, optsArray, goals, isSearchStop}}
     * @private
     */
    _formData: function() {
        var nData = this._notificationData,
            data = {
                script: nData.user.script,
                user_login: nData.user.login,
                client: nData.client,
                validEmails: nData.validEmails
            },
            campaign = this._dataModel.toJSON();

        return u['b-email-notification'].formData(campaign, data);
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('click', 'button', function() {
            this._showPopup();
        });
    }
});
