block('b-campaign-email-notifications')(
    js()(true),

    content()(function() {
        return [
            {
                elem: 'header',
                mix: { block: 'b-modal-popup-decorator', elem: 'header' },
                content: {
                    block: 'b-modal-popup-decorator',
                    elem: 'header-text',
                    content: iget2('b-campaign-email-notifications', 'pochtovye-uvedomleniya', 'Почтовые уведомления')
                }
            },
            {
                elem: 'body',
                mix: { block: 'b-modal-popup-decorator', elem: 'body' },
                notificationData: this.ctx.notificationData
            },
            {
                elem: 'footer',
                mix: { block: 'b-modal-popup-decorator', elem: 'footer' },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: [
                            { block: 'b-campaign-email-notifications', elem: 'accept-button' },
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                        ],
                        content: iget2('b-campaign-email-notifications', 'sohranit', 'Сохранить')
                    },
                    {
                        block: 'button',
                        mix: [
                            { block: 'b-campaign-email-notifications', elem: 'decline-button' },
                            { block: 'b-modal-popup-decorator', elem: 'footer-button' }
                        ],
                        content: iget2('b-campaign-email-notifications', 'otmena', 'Отмена')
                    }
                ]
            }
        ];
    }),

    elem('body').content()(function() {
        var data = this.ctx.notificationData,
            validEmails = data.validEmails;

        return [
            {
                block: 'b-email-notification',
                mods: { extended: 'yes' },
                options: data,
                emailSelect: {
                    block: 'b-email-select',
                    mods: { type: 'campaign' },
                    js: {
                        id: 'email-select',
                        modelName: 'm-email-select',
                        options: validEmails.map(function(val) {
                            return {
                                item: 'option',
                                value: val.email,
                                content: val.email
                            };
                        })
                    },
                    content: {
                        elem: 'select-block',
                        elemMods: { type: 'campaign' },
                        email: data.email,
                        validEmails: validEmails,
                        showAllLink: {
                            block: 'b-email-notification-link',
                            content: [
                                {
                                    block: 'link',
                                    mods: { theme: 'toggler' },
                                    mix: [{ block: 'b-email-notification', elem: 'show-all-email' }],
                                    url: u.formatUrl({
                                        host: data.user.script,
                                        query: {
                                            cmd: 'showUserEmails',
                                            cid: data.campaign.cid,
                                            ulogin: data.user.login
                                        }
                                    }),
                                    content: iget2('b-campaign-email-notifications', 'pokazat-vse', 'Показать все')
                                }
                            ]
                        }
                    }
                }
            },
            {
                block: 'b-email-select',
                js: { id: 'email-select' },
                content: { elem: 'popup-block' }
            }
        ];
    }),

    elem('email-notification-text').tag()('span')
);
