BEM.DOM.decl({ block: 'b-campaign-email-notifications', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            this._notifications = this.findBlockInside('b-email-notification');
            this._subMan = BEM.create('i-subscription-manager');

            u.graspSelf.call(this, {
                _save: 'button on accept-button',
                _cancel: 'button on decline-button'
            });

            this._subMan.on(this._save, 'click', function(e) {
                var valid = this._notifications.validate(),
                    data = this._getData();
                if (valid) {
                    this.trigger('save', data);
                }
            }, this)
                .on(this._cancel, 'click', function(e) {
                    var valid = this._notifications.validate();
                    if (!valid) {
                        this._notifications.reset();
                    }
                    this.trigger('cancel');
                }, this);
        }
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        var deferred = $.Deferred(),
            changed = this._notifications.isChanged();

        deferred.resolve(changed);

        return deferred;
    },

    /**
     * Обновление состояний контролов по данным от родителя
     * Триггерится на force-cancel и save
     * @param {Object} data
     */
    update: function(data) {
        this._notifications.update(data);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();
        this._subMan.destruct();

        this.__base.apply(this);
    },

    /**
     * Получение данных от внутреннего блока
     * @returns {Object}
     * @private
     */
    _getData: function() {
        return this._notifications.getData();
    }
});
