block('b-campaign-group').mod('type', 'content-promotion')(
    elem('banner-preview').def()(function() {
        var ctx = this.ctx,
            group = ctx.group,
            banner = ctx.banner,
            campaign = this.data.campaign,
            mediaType = campaign.mediaType,
            previewBlockName = u['b-banner-preview2'].getNameByType(mediaType);

        return [
            applyCtx({
                block: 'b-campaign-group',
                elem: 'banner-id',
                banner: banner
            }),
            {
                elem: 'preview',
                content: [
                    {
                        block: 'b-banner-preview2',
                        mods: {
                            type: 'content-promotion',
                            view: 'content-promotion-campaign'
                        },
                        data: u[previewBlockName].fromServer({
                            banner: banner,
                            group: group,
                            campaign: campaign
                        }),
                        modelsParams: {
                            dmsIds: {
                                bannerId: banner.modelId,
                                groupId: group.modelId
                            }
                        }
                    },
                    {
                        block: 'b-banner-preview2-warnings',
                        static: banner.warnings
                    }
                ]
            },
            {
                block: 'b-banner-status',
                mods: {
                    updatable: group.isBannersEditable ? 'yes' : ''
                },
                js: {
                    modelParams: {
                        name: u.campaign.getBannerModelName(mediaType),
                        parentName: u.campaign.getGroupModelName(mediaType),
                        parentId: group.modelId,
                        id: banner.modelId
                    }
                },
                banner: banner,
                // Для ДМО не нужно отображать сообщение "Идут показы предыдущей версии баннера" в статусе
                hideOngoingShowsStatus: true
            }
        ];
    })
);
